/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.vectors.mapper;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.SyntheticVectorsPatchFieldLoader;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.vectors.VectorData;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.rank.vectors.RankVectorsPlugin;
import org.elasticsearch.xpack.rank.vectors.mapper.RankVectorsIndexFieldData;

public class RankVectorsFieldMapper
extends FieldMapper {
    public static final String VECTOR_MAGNITUDES_SUFFIX = "._magnitude";
    public static final String CONTENT_TYPE = "rank_vectors";
    private final IndexVersion indexCreatedVersion;
    private final XPackLicenseState licenseState;
    private final boolean isExcludeSourceVectors;

    private static RankVectorsFieldMapper toType(FieldMapper in) {
        return (RankVectorsFieldMapper)in;
    }

    private RankVectorsFieldMapper(String simpleName, MappedFieldType fieldType, FieldMapper.BuilderParams params, IndexVersion indexCreatedVersion, XPackLicenseState licenseState, boolean isExcludeSourceVectors) {
        super(simpleName, fieldType, params);
        this.indexCreatedVersion = indexCreatedVersion;
        this.licenseState = licenseState;
        this.isExcludeSourceVectors = isExcludeSourceVectors;
    }

    public RankVectorsFieldType fieldType() {
        return (RankVectorsFieldType)super.fieldType();
    }

    public boolean parsesArrayValue() {
        return true;
    }

    public void parse(DocumentParserContext context) throws IOException {
        if (!RankVectorsPlugin.RANK_VECTORS_FEATURE.check(this.licenseState)) {
            throw LicenseUtils.newComplianceException((String)"Rank Vectors");
        }
        if (context.doc().getByKey((Object)this.fieldType().name()) != null) {
            throw new IllegalArgumentException("Field [" + this.fullPath() + "] of type [" + this.typeName() + "] doesn't support indexing multiple values for the same field in the same document");
        }
        if (XContentParser.Token.VALUE_NULL == context.parser().currentToken()) {
            return;
        }
        if (XContentParser.Token.START_ARRAY != context.parser().currentToken()) {
            throw new IllegalArgumentException("Field [" + this.fullPath() + "] of type [" + this.typeName() + "] cannot be indexed with a single value");
        }
        if (this.fieldType().dims == null) {
            int currentDims = -1;
            while (XContentParser.Token.END_ARRAY != context.parser().nextToken()) {
                int dims = this.fieldType().element.parseDimensionCount(context);
                if (currentDims == -1) {
                    currentDims = dims;
                    continue;
                }
                if (currentDims == dims) continue;
                throw new IllegalArgumentException("Field [" + this.fullPath() + "] of type [" + this.typeName() + "] cannot be indexed with vectors of different dimensions");
            }
            Builder builder = (Builder)this.getMergeBuilder();
            builder.dimensions(currentDims);
            RankVectorsFieldMapper update = builder.build(context.createDynamicMapperBuilderContext());
            context.addDynamicMapper((Mapper)update);
            return;
        }
        int dims = this.fieldType().dims;
        DenseVectorFieldMapper.Element element = this.fieldType().element;
        ArrayList<VectorData> vectors = new ArrayList<VectorData>();
        while (XContentParser.Token.END_ARRAY != context.parser().nextToken()) {
            VectorData vector = element.parseKnnVector(context, dims, (i, b) -> {
                if (b) {
                    this.checkDimensionMatches(i, context);
                } else {
                    this.checkDimensionExceeded(i, context);
                }
            }, null);
            vectors.add(vector);
        }
        int bufferSize = element.getNumBytes(dims) * vectors.size();
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer magnitudeBuffer = ByteBuffer.allocate(vectors.size() * 4).order(ByteOrder.LITTLE_ENDIAN);
        for (VectorData vector : vectors) {
            vector.addToBuffer(buffer);
            magnitudeBuffer.putFloat((float)Math.sqrt(element.computeSquaredMagnitude(vector)));
        }
        String vectorFieldName = this.fieldType().name();
        String vectorMagnitudeFieldName = vectorFieldName + VECTOR_MAGNITUDES_SUFFIX;
        context.doc().addWithKey((Object)vectorFieldName, (IndexableField)new BinaryDocValuesField(vectorFieldName, new BytesRef(buffer.array())));
        context.doc().addWithKey((Object)vectorMagnitudeFieldName, (IndexableField)new BinaryDocValuesField(vectorMagnitudeFieldName, new BytesRef(magnitudeBuffer.array())));
    }

    private void checkDimensionExceeded(int index, DocumentParserContext context) {
        if (index >= this.fieldType().dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.fullPath() + "] in doc [" + context.documentDescription() + "] has more dimensions than defined in the mapping [" + this.fieldType().dims + "]");
        }
    }

    private void checkDimensionMatches(int index, DocumentParserContext context) {
        if (index != this.fieldType().dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.fullPath() + "] in doc [" + context.documentDescription() + "] has a different number of dimensions [" + index + "] than defined in the mapping [" + this.fieldType().dims + "]");
        }
    }

    protected void parseCreateField(DocumentParserContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexCreatedVersion, this.licenseState, this.isExcludeSourceVectors).init(this);
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> new DocValuesSyntheticFieldLoader());
    }

    public SourceLoader.SyntheticVectorsLoader syntheticVectorsLoader() {
        if (this.isExcludeSourceVectors) {
            return new SyntheticVectorsPatchFieldLoader(() -> new DocValuesSyntheticFieldLoader(), DocValuesSyntheticFieldLoader::copyVectorsAsList);
        }
        return null;
    }

    public static final class RankVectorsFieldType
    extends SimpleMappedFieldType {
        private final DenseVectorFieldMapper.Element element;
        private final Integer dims;
        private final XPackLicenseState licenseState;

        public RankVectorsFieldType(String name, DenseVectorFieldMapper.ElementType elementType, Integer dims, XPackLicenseState licenseState, Map<String, String> meta) {
            super(name, false, false, true, meta);
            this.element = DenseVectorFieldMapper.Element.getElement((DenseVectorFieldMapper.ElementType)elementType);
            this.dims = dims;
            this.licenseState = licenseState;
        }

        public String typeName() {
            return RankVectorsFieldMapper.CONTENT_TYPE;
        }

        public boolean isVectorEmbedding() {
            return true;
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new ArraySourceValueFetcher(this, this.name(), context){

                protected Object parseSourceValue(Object value) {
                    List outerList = (List)value;
                    ArrayList<Object> vectors = new ArrayList<Object>(outerList.size());
                    for (Object o : outerList) {
                        if (o instanceof List) {
                            List innerList = (List)o;
                            float[] vector = new float[innerList.size()];
                            for (int i = 0; i < vector.length; ++i) {
                                vector[i] = ((Number)innerList.get(i)).floatValue();
                            }
                            vectors.add(vector);
                            continue;
                        }
                        vectors.add(o);
                    }
                    return vectors;
                }
            };
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return DocValueFormat.DENSE_VECTOR;
        }

        public boolean isAggregatable() {
            return false;
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            if (!RankVectorsPlugin.RANK_VECTORS_FEATURE.check(this.licenseState)) {
                throw LicenseUtils.newComplianceException((String)"Rank Vectors");
            }
            return new RankVectorsIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, this.dims, this.element.elementType());
        }

        public Query existsQuery(SearchExecutionContext context) {
            return new FieldExistsQuery(this.name());
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support term queries");
        }

        int getVectorDimensions() {
            return this.dims;
        }

        DenseVectorFieldMapper.ElementType getElementType() {
            return this.element.elementType();
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<DenseVectorFieldMapper.ElementType> elementType = new FieldMapper.Parameter("element_type", false, () -> DenseVectorFieldMapper.ElementType.FLOAT, (n, c, o) -> {
            DenseVectorFieldMapper.ElementType elementType = (DenseVectorFieldMapper.ElementType)DenseVectorFieldMapper.namesToElementType.get((String)o);
            if (elementType == null) {
                throw new MapperParsingException("invalid element_type [" + String.valueOf(o) + "]; available types are " + String.valueOf(DenseVectorFieldMapper.namesToElementType.keySet()));
            }
            return elementType;
        }, m -> RankVectorsFieldMapper.toType((FieldMapper)m).fieldType().element.elementType(), XContentBuilder::field, Objects::toString);
        private final FieldMapper.Parameter<Integer> dims = new FieldMapper.Parameter("dims", true, () -> null, (n, c, o) -> {
            if (!(o instanceof Integer)) {
                throw new MapperParsingException("Property [dims] on field [" + n + "] must be an integer but got [" + String.valueOf(o) + "]");
            }
            return XContentMapValues.nodeIntegerValue((Object)o);
        }, m -> RankVectorsFieldMapper.toType((FieldMapper)m).fieldType().dims, XContentBuilder::field, Objects::toString).setSerializerCheck((id, ic, v) -> v != null).setMergeValidator((previous, current, c) -> previous == null || Objects.equals(previous, current)).addValidator(dims -> {
            int minDims;
            if (dims == null) {
                return;
            }
            int maxDims = this.elementType.getValue() == DenseVectorFieldMapper.ElementType.BIT ? 32768 : 4096;
            int n = minDims = this.elementType.getValue() == DenseVectorFieldMapper.ElementType.BIT ? 8 : 1;
            if (dims < minDims || dims > maxDims) {
                throw new MapperParsingException("The number of dimensions should be in the range [" + minDims + ", " + maxDims + "] but was [" + dims + "]");
            }
            if (this.elementType.getValue() == DenseVectorFieldMapper.ElementType.BIT && dims % 8 != 0) {
                throw new MapperParsingException("The number of dimensions for should be a multiple of 8 but was [" + dims + "]");
            }
        });
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final IndexVersion indexCreatedVersion;
        private final XPackLicenseState licenseState;
        private final boolean isExcludeSourceVectors;

        public Builder(String name, IndexVersion indexCreatedVersion, XPackLicenseState licenseState, boolean isExcludeSourceVectors) {
            super(name);
            this.indexCreatedVersion = indexCreatedVersion;
            this.licenseState = licenseState;
            this.isExcludeSourceVectors = isExcludeSourceVectors;
        }

        public Builder dimensions(int dimensions) {
            this.dims.setValue((Object)dimensions);
            return this;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.elementType, this.dims, this.meta};
        }

        public RankVectorsFieldMapper build(MapperBuilderContext context) {
            if (!RankVectorsPlugin.RANK_VECTORS_FEATURE.check(this.licenseState)) {
                throw LicenseUtils.newComplianceException((String)"Rank Vectors");
            }
            this.validate();
            boolean isExcludeSourceVectorsFinal = !context.isSourceSynthetic() && this.isExcludeSourceVectors;
            return new RankVectorsFieldMapper(this.leafName(), (MappedFieldType)new RankVectorsFieldType(context.buildFullName(this.leafName()), (DenseVectorFieldMapper.ElementType)this.elementType.getValue(), (Integer)this.dims.getValue(), this.licenseState, (Map)this.meta.getValue()), this.builderParams((Mapper.Builder)this, context), this.indexCreatedVersion, this.licenseState, isExcludeSourceVectorsFinal);
        }
    }

    private class DocValuesSyntheticFieldLoader
    extends SourceLoader.DocValuesBasedSyntheticFieldLoader {
        private BinaryDocValues values;
        private boolean hasValue;

        private DocValuesSyntheticFieldLoader() {
        }

        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            this.values = leafReader.getBinaryDocValues(RankVectorsFieldMapper.this.fullPath());
            if (this.values == null) {
                return null;
            }
            return docId -> {
                if (this.values.docID() > docId) {
                    this.hasValue = false;
                    return false;
                }
                this.hasValue = this.values.docID() == docId || this.values.advance(docId) == docId;
                return this.hasValue;
            };
        }

        public boolean hasValue() {
            return this.hasValue;
        }

        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            b.startArray(RankVectorsFieldMapper.this.leafName());
            BytesRef ref = this.values.binaryValue();
            ByteBuffer byteBuffer = ByteBuffer.wrap(ref.bytes, ref.offset, ref.length).order(ByteOrder.LITTLE_ENDIAN);
            assert (ref.length % RankVectorsFieldMapper.this.fieldType().element.getNumBytes(RankVectorsFieldMapper.this.fieldType().dims.intValue()) == 0);
            int numVecs = ref.length / RankVectorsFieldMapper.this.fieldType().element.getNumBytes(RankVectorsFieldMapper.this.fieldType().dims.intValue());
            for (int i = 0; i < numVecs; ++i) {
                b.startArray();
                int dims = RankVectorsFieldMapper.this.fieldType().element.elementType() == DenseVectorFieldMapper.ElementType.BIT ? RankVectorsFieldMapper.this.fieldType().dims / 8 : RankVectorsFieldMapper.this.fieldType().dims;
                for (int dim = 0; dim < dims; ++dim) {
                    RankVectorsFieldMapper.this.fieldType().element.readAndWriteValue(byteBuffer, b);
                }
                b.endArray();
            }
            b.endArray();
        }

        private List<List<?>> copyVectorsAsList() throws IOException {
            assert (this.hasValue) : "rank vector is null";
            BytesRef ref = this.values.binaryValue();
            ByteBuffer byteBuffer = ByteBuffer.wrap(ref.bytes, ref.offset, ref.length).order(ByteOrder.LITTLE_ENDIAN);
            assert (ref.length % RankVectorsFieldMapper.this.fieldType().element.getNumBytes(RankVectorsFieldMapper.this.fieldType().dims.intValue()) == 0);
            int numVecs = ref.length / RankVectorsFieldMapper.this.fieldType().element.getNumBytes(RankVectorsFieldMapper.this.fieldType().dims.intValue());
            ArrayList vectors = new ArrayList(numVecs);
            block4: for (int i = 0; i < numVecs; ++i) {
                int dims = RankVectorsFieldMapper.this.fieldType().element.elementType() == DenseVectorFieldMapper.ElementType.BIT ? RankVectorsFieldMapper.this.fieldType().dims / 8 : RankVectorsFieldMapper.this.fieldType().dims;
                switch (RankVectorsFieldMapper.this.fieldType().element.elementType()) {
                    case FLOAT: {
                        int dim;
                        ArrayList<Number> vec = new ArrayList<Number>(dims);
                        for (dim = 0; dim < dims; ++dim) {
                            vec.add(Float.valueOf(byteBuffer.getFloat()));
                        }
                        vectors.add(vec);
                        continue block4;
                    }
                    case BYTE: 
                    case BIT: {
                        int dim;
                        ArrayList<Number> vec = new ArrayList(dims);
                        for (dim = 0; dim < dims; ++dim) {
                            vec.add(byteBuffer.get());
                        }
                        vectors.add(vec);
                    }
                }
            }
            return vectors;
        }

        public String fieldName() {
            return RankVectorsFieldMapper.this.fullPath();
        }
    }
}

