/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.SearchResults;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import java.util.function.LongToIntFunction;

public class BruteForceQuery {
    private final LongToIntFunction mapping;
    private final float[][] queryVectors;
    private final BitSet[] prefilters;
    private int numDocs = -1;
    private final int topK;
    private final CuVSResources resources;

    public BruteForceQuery(float[][] queryVectors, LongToIntFunction mapping, int topK, BitSet[] prefilters, int numDocs, CuVSResources resources) {
        this.queryVectors = queryVectors;
        this.mapping = mapping;
        this.topK = topK;
        this.prefilters = prefilters;
        this.numDocs = numDocs;
        this.resources = resources;
    }

    public float[][] getQueryVectors() {
        return this.queryVectors;
    }

    public LongToIntFunction getMapping() {
        return this.mapping;
    }

    public int getTopK() {
        return this.topK;
    }

    public BitSet[] getPrefilters() {
        return this.prefilters;
    }

    public int getNumDocs() {
        return this.numDocs;
    }

    public CuVSResources getResources() {
        return this.resources;
    }

    public String toString() {
        return "BruteForceQuery [mapping=" + String.valueOf(this.mapping) + ", queryVectors=" + Arrays.toString((Object[])this.queryVectors) + ", prefilter=" + Arrays.toString(this.prefilters) + ", topK=" + this.topK + "]";
    }

    public static class Builder {
        private float[][] queryVectors;
        private BitSet[] prefilters;
        private int numDocs;
        private LongToIntFunction mapping = SearchResults.IDENTITY_MAPPING;
        private int topK = 2;
        private final CuVSResources resources;

        public Builder(CuVSResources resources) {
            this.resources = Objects.requireNonNull(resources, "resources cannot be null");
        }

        public Builder withQueryVectors(float[][] queryVectors) {
            this.queryVectors = queryVectors;
            return this;
        }

        public Builder withMapping(LongToIntFunction mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder withTopK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder withPrefilters(BitSet[] prefilters, int numDocs) {
            this.prefilters = prefilters;
            this.numDocs = numDocs;
            return this;
        }

        public BruteForceQuery build() {
            return new BruteForceQuery(this.queryVectors, this.mapping, this.topK, this.prefilters, this.numDocs, this.resources);
        }
    }
}

