/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import org.apache.lucene.util.RamUsageEstimator;

class RamEstimationUtil {
    RamEstimationUtil() {
    }

    private static long estimatedArraySize(int arrayLength, int bytesPerElement) {
        return RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)arrayLength * (long)bytesPerElement));
    }

    static long estimateLongArray(int length) {
        return RamEstimationUtil.estimatedArraySize(length, 8);
    }

    static long estimateIntArray(int length) {
        return RamEstimationUtil.estimatedArraySize(length, 4);
    }

    static long estimateDoubleArray(int length) {
        return RamEstimationUtil.estimatedArraySize(length, 8);
    }
}

