/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.stats.MappingVisitor;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldMapper;

record TimeSeriesFields(String[] metricFields, String[] dimensionFields, String[] labelFields, Map<String, String> multiFieldSources) {
    public static final Set<TimeSeriesParams.MetricType> METRIC_TYPES = Set.of(TimeSeriesParams.MetricType.values());

    static boolean isTimeSeriesLabel(String field, MapperService mapperService, String timestampField) {
        MappingLookup lookup = mapperService.mappingLookup();
        MappedFieldType fieldType = lookup.getFieldType(field);
        return fieldType != null && !timestampField.equals(field) && fieldType.isAggregatable() && !fieldType.isDimension() && !mapperService.isMetadataField(field);
    }

    static boolean isTimeSeriesMetric(Map<String, ?> fieldMapping) {
        String metricType = (String)fieldMapping.get("time_series_metric");
        return metricType != null && METRIC_TYPES.contains(TimeSeriesParams.MetricType.fromString((String)metricType));
    }

    static class Collector {
        private final MapperService mapperService;
        private final String timestampField;
        private final Set<String> metricFields = new HashSet<String>();
        private final Set<String> dimensionFields = new HashSet<String>();
        private final Set<String> labelFields = new HashSet<String>();
        private final Map<String, String> alternativeSources = new HashMap<String, String>();

        Collector(MapperService mapperService, String timestampField) {
            this.mapperService = mapperService;
            this.timestampField = timestampField;
        }

        public TimeSeriesFields collect(Map<String, ?> mapping) {
            MappingVisitor.visitMapping(mapping, this::trackFields, this::trackMultiFields);
            return new TimeSeriesFields((String[])this.metricFields.toArray(String[]::new), (String[])this.dimensionFields.toArray(String[]::new), (String[])this.labelFields.toArray(String[]::new), Collections.unmodifiableMap(this.alternativeSources));
        }

        private void trackFields(String field, Map<String, ?> mapping) {
            List<String> flattenedDimensions = this.extractFlattenedDimensions(field, mapping);
            if (flattenedDimensions != null) {
                this.dimensionFields.addAll(flattenedDimensions);
            } else if (this.isTimeSeriesDimension(mapping)) {
                this.dimensionFields.add(field);
            } else if (TimeSeriesFields.isTimeSeriesMetric(mapping)) {
                this.metricFields.add(field);
            } else if (this.isTimeSeriesLabel(field)) {
                this.labelFields.add(field);
            }
        }

        private void trackMultiFields(String field, Map<String, ?> mapping) {
            if (TimeSeriesFields.isTimeSeriesMetric(mapping)) {
                throw new IllegalArgumentException("Downsampling failed because index mapping contains time series metrics as a multi field [" + field + "]");
            }
            String parentField = field.substring(0, field.lastIndexOf(46));
            if (this.dimensionFields.contains(parentField) || this.metricFields.contains(parentField)) {
                return;
            }
            if (this.isTimeSeriesDimension(mapping)) {
                this.dimensionFields.add(parentField);
                this.labelFields.remove(parentField);
                this.alternativeSources.put(parentField, field);
            } else if (this.isTimeSeriesLabel(field) && !this.labelFields.contains(parentField)) {
                this.labelFields.add(parentField);
                this.alternativeSources.put(parentField, field);
            }
        }

        public boolean isTimeSeriesLabel(String field) {
            return TimeSeriesFields.isTimeSeriesLabel(field, this.mapperService, this.timestampField);
        }

        public boolean isTimeSeriesDimension(Map<String, ?> fieldMapping) {
            return Boolean.TRUE.equals(fieldMapping.get("time_series_dimension")) && !Collector.isPassthroughField(fieldMapping);
        }

        public static boolean isPassthroughField(Map<String, ?> fieldMapping) {
            return "passthrough".equals(fieldMapping.get("type"));
        }

        public List<String> extractFlattenedDimensions(String field, Map<String, ?> fieldMapping) {
            Mapper mapper = this.mapperService.mappingLookup().getMapper(field);
            if (!(mapper instanceof FlattenedFieldMapper)) {
                return null;
            }
            Object dimensions = fieldMapping.get("time_series_dimensions");
            if (dimensions instanceof List) {
                List actualList = (List)dimensions;
                return actualList.stream().map(field_in_flattened -> field + "." + String.valueOf(field_in_flattened)).toList();
            }
            return null;
        }
    }
}

