/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorServiceTypeAction {
    public static final String NAME = "cluster:admin/xpack/connector/update_service_type";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("cluster:admin/xpack/connector/update_service_type");

    private UpdateConnectorServiceTypeAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final String serviceType;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_service_type_request", false, (args, connectorId) -> new Request((String)connectorId, (String)args[0]));

        public Request(String connectorId, String serviceType) {
            this.connectorId = connectorId;
            this.serviceType = serviceType;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.serviceType = in.readString();
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Connector.SERVICE_TYPE_FIELD.getPreferredName(), this.serviceType);
            builder.endObject();
            return builder;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be [null] or [\"\"].", validationException);
            }
            if (Strings.isNullOrEmpty((String)this.serviceType)) {
                validationException = ValidateActions.addValidationError((String)"[service_type] cannot be [null] or [\"\"].", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeString(this.serviceType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.serviceType, request.serviceType);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.serviceType);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), Connector.SERVICE_TYPE_FIELD);
        }
    }
}

