/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics.action;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.analytics.event.AnalyticsEvent;

@Deprecated
public class PostAnalyticsEventAction {
    public static final String NAME = "cluster:admin/xpack/application/analytics/post_event";
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/xpack/application/analytics/post_event");

    private PostAnalyticsEventAction() {
    }

    public static class DebugResponse
    extends Response {
        private static final ParseField EVENT_FIELD = new ParseField("event", new String[0]);
        private final AnalyticsEvent analyticsEvent;

        public DebugResponse(boolean accepted, AnalyticsEvent analyticsEvent) {
            super(accepted);
            this.analyticsEvent = Objects.requireNonNull(analyticsEvent, "analyticsEvent cannot be null");
        }

        @Override
        public boolean isDebug() {
            return true;
        }

        public AnalyticsEvent analyticsEvent() {
            return this.analyticsEvent;
        }

        @Override
        protected void addFieldsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(EVENT_FIELD.getPreferredName(), (ToXContent)this.analyticsEvent());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.analyticsEvent.writeTo(out);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            DebugResponse that = (DebugResponse)((Object)o);
            return super.equals(o) && this.analyticsEvent.equals(that.analyticsEvent);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Objects.hashCode(this.analyticsEvent);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final Response ACCEPTED = new Response(true);
        private static final ParseField RESULT_FIELD = new ParseField("accepted", new String[0]);
        private final boolean accepted;
        private static final ConstructingObjectParser<Response, String> PARSER = new ConstructingObjectParser("post_analytics_event_response", false, params -> new Response((Boolean)params[0]));

        public static Response readFromStreamInput(StreamInput in) throws IOException {
            boolean accepted = in.readBoolean();
            boolean isDebug = in.readBoolean();
            if (isDebug) {
                return new DebugResponse(accepted, new AnalyticsEvent(in));
            }
            return new Response(accepted);
        }

        public Response(boolean accepted) {
            this.accepted = accepted;
        }

        public boolean isAccepted() {
            return this.accepted;
        }

        public boolean isDebug() {
            return false;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.accepted);
            out.writeBoolean(this.isDebug());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return this.accepted == that.accepted && this.isDebug() == that.isDebug();
        }

        public int hashCode() {
            return Objects.hash(this.accepted, this.isDebug());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(RESULT_FIELD.getPreferredName(), this.accepted);
            this.addFieldsToXContent(builder, params);
            return builder.endObject();
        }

        protected void addFieldsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        }

        public static Response parse(XContentParser parser) {
            return (Response)((Object)PARSER.apply(parser, null));
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), RESULT_FIELD);
        }
    }

    public static class RequestBuilder {
        private String eventCollectionName;
        private String eventType;
        private long eventTime = System.currentTimeMillis();
        private boolean debug = false;
        private BytesReference payload;
        private XContentType xContentType;
        private Map<String, List<String>> headers;
        private String clientAddress;

        private RequestBuilder(String eventCollectionName, String eventType, XContentType xContentType, BytesReference payload) {
            this.eventCollectionName = eventCollectionName;
            this.eventType = eventType;
            this.xContentType = xContentType;
            this.payload = payload;
        }

        public Request request() {
            return new Request(this.eventCollectionName, this.eventType, this.eventTime, this.xContentType, this.payload, this.debug, this.headers, this.clientAddress);
        }

        public RequestBuilder eventCollectionName(String eventCollectionName) {
            this.eventCollectionName = eventCollectionName;
            return this;
        }

        public RequestBuilder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public RequestBuilder eventTime(long eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public RequestBuilder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public RequestBuilder payload(BytesReference payload) {
            this.payload = payload;
            return this;
        }

        public RequestBuilder xContentType(XContentType xContentType) {
            this.xContentType = xContentType;
            return this;
        }

        public RequestBuilder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public RequestBuilder clientAddress(InetAddress clientAddress) {
            return this.clientAddress(NetworkAddress.format((InetAddress)clientAddress));
        }

        public RequestBuilder clientAddress(String clientAddress) {
            this.clientAddress = clientAddress;
            return this;
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements AnalyticsEvent.Context,
    ToXContentObject {
        private final String eventCollectionName;
        private final String eventType;
        private final long eventTime;
        private final boolean debug;
        private final BytesReference payload;
        private final XContentType xContentType;
        private final Map<String, List<String>> headers;
        private final String clientAddress;

        private Request(String eventCollectionName, String eventType, long eventTime, XContentType xContentType, BytesReference payload, boolean debug, @Nullable Map<String, List<String>> headers, @Nullable String clientAddress) {
            this.eventCollectionName = eventCollectionName;
            this.eventType = eventType;
            this.debug = debug;
            this.eventTime = eventTime;
            this.xContentType = xContentType;
            this.payload = payload;
            this.headers = Objects.requireNonNullElse(headers, Map.of());
            this.clientAddress = clientAddress;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.eventCollectionName = in.readString();
            this.eventType = in.readString();
            this.debug = in.readBoolean();
            this.eventTime = in.readLong();
            this.xContentType = (XContentType)in.readEnum(XContentType.class);
            this.payload = in.readBytesReference();
            this.headers = in.readMap(StreamInput::readStringCollectionAsList);
            this.clientAddress = in.readOptionalString();
        }

        public static RequestBuilder builder(String eventCollectionName, String eventType, XContentType xContentType, BytesReference payload) {
            return new RequestBuilder(eventCollectionName, eventType, xContentType, payload);
        }

        @Override
        public String eventCollectionName() {
            return this.eventCollectionName;
        }

        @Override
        public AnalyticsEvent.Type eventType() {
            return AnalyticsEvent.Type.valueOf(this.eventType.toUpperCase(Locale.ROOT));
        }

        @Override
        public long eventTime() {
            return this.eventTime;
        }

        @Override
        public String userAgent() {
            return this.header("User-Agent");
        }

        @Override
        public String clientAddress() {
            return this.clientAddress;
        }

        public BytesReference payload() {
            return this.payload;
        }

        public XContentType xContentType() {
            return this.xContentType;
        }

        public boolean isDebug() {
            return this.debug;
        }

        private String header(String header) {
            List<String> values = this.headers.get(header);
            if (values != null && !values.isEmpty()) {
                return values.get(0);
            }
            return null;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.eventCollectionName)) {
                validationException = ValidateActions.addValidationError((String)"collection name is missing", validationException);
            }
            if (Strings.isNullOrEmpty((String)this.eventType)) {
                validationException = ValidateActions.addValidationError((String)"event type is missing", (ActionRequestValidationException)validationException);
            }
            try {
                if (!this.eventType.toLowerCase(Locale.ROOT).equals(this.eventType)) {
                    throw new IllegalArgumentException("event type must be lowercase");
                }
                AnalyticsEvent.Type.valueOf(this.eventType.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                validationException = ValidateActions.addValidationError((String)Strings.format((String)"invalid event type: [%s]", (Object[])new Object[]{this.eventType}), (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.eventCollectionName);
            out.writeString(this.eventType);
            out.writeBoolean(this.debug);
            out.writeLong(this.eventTime);
            XContentHelper.writeTo((StreamOutput)out, (XContentType)this.xContentType);
            out.writeBytesReference(this.payload);
            out.writeMap(this.headers, StreamOutput::writeStringCollection);
            out.writeOptionalString(this.clientAddress);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Objects.equals(this.eventCollectionName, that.eventCollectionName) && this.debug == that.debug && this.eventTime == that.eventTime && Objects.equals(this.eventType, that.eventType) && Objects.equals(this.xContentType.canonical(), that.xContentType.canonical()) && Objects.equals(this.payload, that.payload) && Objects.equals(this.headers, that.headers) && Objects.equals(this.clientAddress, that.clientAddress);
        }

        public int hashCode() {
            return Objects.hash(this.eventCollectionName, this.eventType, this.debug, this.eventTime, this.xContentType.canonical(), this.payload, this.headers, this.clientAddress);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("event_collection_name", this.eventCollectionName);
            builder.field("debug", this.debug);
            builder.field("event_time", this.eventTime);
            builder.field("event_type", this.eventType);
            builder.field("x_content_type", (Enum)this.xContentType);
            builder.field("payload", (ToXContent)this.payload);
            builder.field("headers", this.headers);
            builder.field("client_address", this.clientAddress);
            builder.endObject();
            return builder;
        }
    }
}

