/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.sagemaker.schema.openai;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.inference.results.ChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEvent;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.unified.UnifiedChatCompletionRequestEntity;
import org.elasticsearch.xpack.inference.services.openai.OpenAiStreamingProcessor;
import org.elasticsearch.xpack.inference.services.openai.OpenAiUnifiedChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.openai.OpenAiUnifiedStreamingProcessor;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiChatCompletionResponseEntity;
import org.elasticsearch.xpack.inference.services.sagemaker.SageMakerInferenceRequest;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerModel;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStoredTaskSchema;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStreamSchemaPayload;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.openai.SageMakerOpenAiTaskSettings;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointResponse;

public class OpenAiCompletionPayload
implements SageMakerStreamSchemaPayload {
    private static final XContent jsonXContent = JsonXContent.jsonXContent;
    private static final String APPLICATION_JSON = jsonXContent.type().mediaTypeWithoutParameters();
    private static final XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
    private static final String USER_FIELD = "user";
    private static final String USER_ROLE = "user";
    private static final String MAX_COMPLETION_TOKENS_FIELD = "max_completion_tokens";
    private static final ResponseHandler ERROR_HANDLER = new OpenAiUnifiedChatCompletionResponseHandler("sagemaker openai chat completion", (request, result) -> {
        assert (false) : "do not call this";
        throw new UnsupportedOperationException("SageMaker should not call this object's response parser.");
    });

    @Override
    public SdkBytes chatCompletionRequestBytes(SageMakerModel model, UnifiedCompletionRequest request) throws Exception {
        return this.completion(model, new UnifiedChatCompletionRequestEntity(request, true), request.maxCompletionTokens());
    }

    private SdkBytes completion(SageMakerModel model, UnifiedChatCompletionRequestEntity requestEntity, @Nullable Long maxCompletionTokens) throws Exception {
        SageMakerStoredTaskSchema sageMakerStoredTaskSchema = model.apiTaskSettings();
        if (sageMakerStoredTaskSchema instanceof SageMakerOpenAiTaskSettings) {
            SageMakerOpenAiTaskSettings apiTaskSettings = (SageMakerOpenAiTaskSettings)sageMakerStoredTaskSchema;
            return SdkBytes.fromUtf8String((String)Strings.toString((builder, params) -> {
                requestEntity.toXContent(builder, params);
                if (!Strings.isNullOrEmpty((String)apiTaskSettings.user())) {
                    builder.field("user", apiTaskSettings.user());
                }
                if (maxCompletionTokens != null) {
                    builder.field(MAX_COMPLETION_TOKENS_FIELD, maxCompletionTokens);
                }
                return builder;
            }));
        }
        throw this.createUnsupportedSchemaException(model);
    }

    @Override
    public StreamingUnifiedChatCompletionResults.Results chatCompletionResponseBody(SageMakerModel model, SdkBytes response) {
        Stream<ServerSentEvent> serverSentEvents = this.serverSentEvents(response);
        ArrayDeque results = serverSentEvents.flatMap(event -> {
            if ("error".equals(event.type())) {
                throw OpenAiUnifiedChatCompletionResponseHandler.buildMidStreamError(model.getInferenceEntityId(), event.data(), null);
            }
            try {
                return OpenAiUnifiedStreamingProcessor.parse(parserConfig, event);
            }
            catch (Exception e) {
                throw OpenAiUnifiedChatCompletionResponseHandler.buildMidStreamError(model.getInferenceEntityId(), event.data(), e);
            }
        }).collect(() -> new ArrayDeque(), ArrayDeque::offer, ArrayDeque::addAll);
        return new StreamingUnifiedChatCompletionResults.Results((Deque)results);
    }

    private Stream<ServerSentEvent> serverSentEvents(SdkBytes response) {
        return new ServerSentEventParser().parse(response.asByteArray()).stream().filter(ServerSentEvent::hasData);
    }

    @Override
    public String api() {
        return "openai";
    }

    @Override
    public SageMakerStoredTaskSchema apiTaskSettings(Map<String, Object> taskSettings, ValidationException validationException) {
        return SageMakerOpenAiTaskSettings.fromMap(taskSettings, validationException);
    }

    @Override
    public Stream<NamedWriteableRegistry.Entry> namedWriteables() {
        return Stream.of(new NamedWriteableRegistry.Entry(SageMakerStoredTaskSchema.class, "sagemaker_openai_task_settings", SageMakerOpenAiTaskSettings::new));
    }

    @Override
    public String accept(SageMakerModel model) {
        return APPLICATION_JSON;
    }

    @Override
    public String contentType(SageMakerModel model) {
        return APPLICATION_JSON;
    }

    @Override
    public SdkBytes requestBytes(SageMakerModel model, SageMakerInferenceRequest request) throws Exception {
        return this.completion(model, new UnifiedChatCompletionRequestEntity(new UnifiedChatInput(request.input(), "user", request.stream())), null);
    }

    public ChatCompletionResults responseBody(SageMakerModel model, InvokeEndpointResponse response) throws Exception {
        return OpenAiChatCompletionResponseEntity.fromResponse(response.body().asByteArray());
    }

    @Override
    public StreamingChatCompletionResults.Results streamResponseBody(SageMakerModel model, SdkBytes response) {
        Stream<ServerSentEvent> serverSentEvents = this.serverSentEvents(response);
        ArrayDeque results = serverSentEvents.flatMap(event -> OpenAiStreamingProcessor.parse(parserConfig, event)).collect(() -> new ArrayDeque(), ArrayDeque::offer, ArrayDeque::addAll);
        return new StreamingChatCompletionResults.Results((Deque)results);
    }
}

