/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.request;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.azureaistudio.request.AzureAiStudioRequest;
import org.elasticsearch.xpack.inference.services.azureaistudio.request.AzureAiStudioRerankRequestEntity;
import org.elasticsearch.xpack.inference.services.azureaistudio.rerank.AzureAiStudioRerankModel;

public class AzureAiStudioRerankRequest
extends AzureAiStudioRequest {
    private final String query;
    private final List<String> input;
    private final Boolean returnDocuments;
    private final Integer topN;
    private final AzureAiStudioRerankModel rerankModel;

    public AzureAiStudioRerankRequest(AzureAiStudioRerankModel model, String query, List<String> input, @Nullable Boolean returnDocuments, @Nullable Integer topN) {
        super(model);
        this.rerankModel = Objects.requireNonNull(model);
        this.query = query;
        this.input = Objects.requireNonNull(input);
        this.returnDocuments = returnDocuments;
        this.topN = topN;
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)this.createRequestEntity()).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        this.setAuthHeader((HttpEntityEnclosingRequestBase)httpPost, this.rerankModel);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    private AzureAiStudioRerankRequestEntity createRequestEntity() {
        return new AzureAiStudioRerankRequestEntity(this.query, this.input, this.returnDocuments, this.topN, this.rerankModel.getTaskSettings());
    }
}

