/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch.completion;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class AlibabaCloudSearchCompletionTaskSettings
implements TaskSettings {
    public static final String NAME = "alibabacloud_search_completion_task_settings";
    public static final String PARAMETERS = "parameters";
    static final AlibabaCloudSearchCompletionTaskSettings EMPTY_SETTINGS = new AlibabaCloudSearchCompletionTaskSettings((Map<String, Object>)null);
    private final Map<String, Object> parameters;

    public static AlibabaCloudSearchCompletionTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        Map parameters = ServiceUtils.removeAsType(map, PARAMETERS, Map.class, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return AlibabaCloudSearchCompletionTaskSettings.of(parameters);
    }

    public static AlibabaCloudSearchCompletionTaskSettings of(AlibabaCloudSearchCompletionTaskSettings originalSettings, AlibabaCloudSearchCompletionTaskSettings requestTaskSettings) {
        if (originalSettings != null && originalSettings.parameters != null && requestTaskSettings != null && requestTaskSettings.parameters != null) {
            HashMap<String, Object> copy = new HashMap<String, Object>(originalSettings.parameters);
            requestTaskSettings.parameters.forEach((key, value) -> copy.merge((String)key, value, (originalValue, requestValue) -> requestValue));
            return new AlibabaCloudSearchCompletionTaskSettings(copy);
        }
        return new AlibabaCloudSearchCompletionTaskSettings(requestTaskSettings.getParameters() != null ? requestTaskSettings.getParameters() : originalSettings.getParameters());
    }

    public static AlibabaCloudSearchCompletionTaskSettings of(Map<String, Object> parameters) {
        return new AlibabaCloudSearchCompletionTaskSettings(parameters);
    }

    public AlibabaCloudSearchCompletionTaskSettings(StreamInput in) throws IOException {
        this(in.readGenericMap());
    }

    public AlibabaCloudSearchCompletionTaskSettings(@Nullable Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public boolean isEmpty() {
        return this.parameters == null || this.parameters.isEmpty();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.parameters != null && !this.parameters.isEmpty()) {
            builder.field(PARAMETERS, this.parameters);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericMap(this.parameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlibabaCloudSearchCompletionTaskSettings that = (AlibabaCloudSearchCompletionTaskSettings)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        AlibabaCloudSearchCompletionTaskSettings updatedSettings = AlibabaCloudSearchCompletionTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return AlibabaCloudSearchCompletionTaskSettings.of(this, updatedSettings);
    }
}

