/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.operator.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;

public final class Maths {
    public static Number round(Number n, long precision) throws ArithmeticException {
        int sign;
        if (n instanceof Long || n instanceof Integer || n instanceof Short || n instanceof Byte) {
            return Maths.convertToIntegerType(Maths.round(n.longValue(), precision), n.getClass());
        }
        double nDouble = n.doubleValue();
        if (Double.isNaN(nDouble)) {
            return n instanceof Float ? 0.0 : 0.0;
        }
        double tenAtScale = Maths.tenPower(precision);
        if (tenAtScale == 0.0 || nDouble == 0.0) {
            return n instanceof Float ? 0.0 : 0.0;
        }
        double middleResult = nDouble * tenAtScale;
        int n2 = sign = middleResult >= 0.0 ? 1 : -1;
        if (Double.POSITIVE_INFINITY == middleResult || Double.NEGATIVE_INFINITY == middleResult) {
            return n;
        }
        if (-9.223372036854776E18 < middleResult && middleResult < 9.223372036854776E18) {
            Double result = (double)Math.round(Math.abs(middleResult)) / tenAtScale * (double)sign;
            return n instanceof Float ? (double)result.floatValue() : result;
        }
        MathContext prec = MathContext.DECIMAL128;
        Double result = new BigDecimal(Math.abs(middleResult), prec).round(new MathContext(0)).divide(new BigDecimal(tenAtScale), prec).doubleValue() * (double)sign;
        return n instanceof Float ? (double)result.floatValue() : result;
    }

    public static BigInteger round(BigInteger n, long precision) throws ArithmeticException {
        BigInteger having;
        if (n.signum() == 0 || precision > 0L) {
            return n;
        }
        int digitsToRound = DataTypeConverter.safeToInt(-precision);
        BigInteger tenAtScaleMinusOne = BigInteger.TEN.pow(digitsToRound - 1);
        BigInteger tenAtScale = tenAtScaleMinusOne.multiply(BigInteger.TEN);
        BigInteger middleResult = n.divide(tenAtScale);
        BigInteger remainder = n.mod(tenAtScale);
        if (remainder.compareTo(having = tenAtScaleMinusOne.multiply(BigInteger.valueOf(5L))) >= 0) {
            middleResult = middleResult.add(BigInteger.ONE);
        } else if (remainder.compareTo(having.negate()) <= 0) {
            middleResult = middleResult.subtract(BigInteger.ONE);
        }
        return middleResult.multiply(tenAtScale);
    }

    public static Long round(long n, long precision) throws ArithmeticException {
        if (n == 0L || precision >= 0L) {
            return n;
        }
        long digitsToRound = -precision;
        int digits = (int)(Math.log10(Math.abs((double)n)) + 1.0);
        if ((long)digits <= digitsToRound) {
            return 0L;
        }
        long tenAtScaleMinusOne = (long)Maths.tenPower(digitsToRound - 1L);
        long tenAtScale = tenAtScaleMinusOne * 10L;
        long middleResult = n / tenAtScale;
        long remainder = n % tenAtScale;
        long halving = 5L * tenAtScaleMinusOne;
        if (remainder >= halving) {
            ++middleResult;
        } else if (remainder <= -halving) {
            --middleResult;
        }
        long result = middleResult * tenAtScale;
        if (Long.signum(result) == Long.signum(n)) {
            return result;
        }
        throw new ArithmeticException("long overflow");
    }

    public static Number truncate(Number n, Number precision) {
        long longPrecision = precision.longValue();
        if (n instanceof Long || n instanceof Integer || n instanceof Short || n instanceof Byte) {
            long nLong = n.longValue();
            if (nLong == 0L || longPrecision >= 0L) {
                return n;
            }
            long digitsToTruncate = -longPrecision;
            int digits = (int)(Math.log10(Math.abs(n.doubleValue())) + 1.0);
            if ((long)digits <= digitsToTruncate) {
                return Maths.convertToIntegerType(0L, n.getClass());
            }
            long tenAtScale = (long)Maths.tenPower(digitsToTruncate);
            return Maths.convertToIntegerType(nLong / tenAtScale * tenAtScale, n.getClass());
        }
        double tenAtScale = Math.pow(10.0, longPrecision);
        double g = n.doubleValue() * tenAtScale;
        Double result = (n.doubleValue() < 0.0 ? Math.ceil(g) : Math.floor(g)) / tenAtScale;
        return n instanceof Float ? (double)result.floatValue() : result;
    }

    private static double tenPower(long n) {
        if (n == 0L) {
            return 1.0;
        }
        if (n == 1L) {
            return 10.0;
        }
        if (n == 2L) {
            return 100.0;
        }
        if (n == 3L) {
            return 1000.0;
        }
        if (n == 4L) {
            return 10000.0;
        }
        if (n == 5L) {
            return 100000.0;
        }
        return Math.pow(10.0, n);
    }

    private static Number convertToIntegerType(Long number, Class<? extends Number> type) throws ArithmeticException {
        if (type == Integer.class) {
            if (number > Integer.MAX_VALUE || number < Integer.MIN_VALUE) {
                throw new ArithmeticException("integer overflow");
            }
            return number.intValue();
        }
        if (type == Short.class) {
            return number.shortValue();
        }
        if (type == Byte.class) {
            return number.byteValue();
        }
        return number;
    }
}

