/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;

public final class HistoBackedSumAggregator
extends NumericMetricsAggregator.SingleValue {
    private final HistogramValuesSource.Histogram valuesSource;
    private final DocValueFormat format;
    private DoubleArray sums;
    private DoubleArray compensations;

    public HistoBackedSumAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (HistogramValuesSource.Histogram)valuesSourceConfig.getValuesSource();
        this.format = valuesSourceConfig.format();
        this.sums = this.bigArrays().newDoubleArray(1L, true);
        this.compensations = this.bigArrays().newDoubleArray(1L, true);
    }

    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final HistogramValues values = this.valuesSource.getHistogramValues(aggCtx.getLeafReaderContext());
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                HistoBackedSumAggregator.this.sums = HistoBackedSumAggregator.this.bigArrays().grow(HistoBackedSumAggregator.this.sums, bucket + 1L);
                HistoBackedSumAggregator.this.compensations = HistoBackedSumAggregator.this.bigArrays().grow(HistoBackedSumAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    HistogramValue sketch = values.histogram();
                    double sum = HistoBackedSumAggregator.this.sums.get(bucket);
                    double compensation = HistoBackedSumAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    while (sketch.next()) {
                        double d = sketch.value() * (double)sketch.count();
                        kahanSummation.add(d);
                    }
                    HistoBackedSumAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    HistoBackedSumAggregator.this.sums.set(bucket, kahanSummation.value());
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        if (owningBucketOrd >= this.sums.size()) {
            return 0.0;
        }
        return this.sums.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new Sum(this.name, this.sums.get(bucket), this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return Sum.empty((String)this.name, (DocValueFormat)this.format, (Map)this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.sums, this.compensations});
    }
}

