/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.elasticsearch.common.regex.Regex;

public class SSLExceptionHelper {
    private SSLExceptionHelper() {
    }

    public static boolean isNotSslRecordException(Throwable e) {
        return e instanceof DecoderException && e.getCause() instanceof NotSslRecordException;
    }

    public static boolean isCloseDuringHandshakeException(Throwable e) {
        return SSLExceptionHelper.isCloseDuringHandshakeSSLException(e) || SSLExceptionHelper.isCloseDuringHandshakeSSLException(e.getCause());
    }

    private static boolean isCloseDuringHandshakeSSLException(Throwable e) {
        return e instanceof SSLException && e.getCause() == null && "Received close_notify during handshake".equals(e.getMessage());
    }

    public static boolean isReceivedCertificateUnknownException(Throwable e) {
        return e instanceof DecoderException && e.getCause() instanceof SSLException && "Received fatal alert: certificate_unknown".equals(e.getCause().getMessage());
    }

    public static boolean isInsufficientBufferRemainingException(Throwable e) {
        return e instanceof DecoderException && e.getCause() instanceof SSLHandshakeException && Regex.simpleMatch((String)"Insufficient buffer remaining for AEAD cipher fragment*", (String)e.getCause().getMessage());
    }
}

