/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.system_indices.action;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.system_indices.action.GetFeatureUpgradeStatusRequest;
import org.elasticsearch.system_indices.action.GetFeatureUpgradeStatusResponse;
import org.elasticsearch.system_indices.task.FeatureMigrationResults;
import org.elasticsearch.system_indices.task.SingleFeatureMigrationResult;
import org.elasticsearch.system_indices.task.SystemIndexMigrationTaskState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetFeatureUpgradeStatusAction
extends TransportMasterNodeAction<GetFeatureUpgradeStatusRequest, GetFeatureUpgradeStatusResponse> {
    private final SystemIndices systemIndices;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportGetFeatureUpgradeStatusAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, ClusterService clusterService, SystemIndices systemIndices, ProjectResolver projectResolver) {
        super("cluster:admin/migration/get_system_feature", transportService, clusterService, threadPool, actionFilters, GetFeatureUpgradeStatusRequest::new, GetFeatureUpgradeStatusResponse::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndices = systemIndices;
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, GetFeatureUpgradeStatusRequest request, ClusterState state, ActionListener<GetFeatureUpgradeStatusResponse> listener) throws Exception {
        ProjectMetadata project = this.projectResolver.getProjectMetadata(state);
        List<GetFeatureUpgradeStatusResponse.FeatureUpgradeStatus> features = this.systemIndices.getFeatures().stream().sorted(Comparator.comparing(SystemIndices.Feature::getName)).map(feature -> TransportGetFeatureUpgradeStatusAction.getFeatureUpgradeStatus(project, feature)).toList();
        boolean migrationTaskExists = PersistentTasksCustomMetadata.getTaskWithId((ProjectMetadata)project, (String)"upgrade-system-indices") != null;
        GetFeatureUpgradeStatusResponse.UpgradeStatus initalStatus = migrationTaskExists ? GetFeatureUpgradeStatusResponse.UpgradeStatus.IN_PROGRESS : GetFeatureUpgradeStatusResponse.UpgradeStatus.NO_MIGRATION_NEEDED;
        GetFeatureUpgradeStatusResponse.UpgradeStatus status = Stream.concat(Stream.of(initalStatus), features.stream().map(GetFeatureUpgradeStatusResponse.FeatureUpgradeStatus::getUpgradeStatus)).reduce((xva$0, xva$1) -> GetFeatureUpgradeStatusResponse.UpgradeStatus.combine(xva$0, xva$1)).orElseGet(() -> {
            assert (false) : "get feature statuses API doesn't have any features";
            return GetFeatureUpgradeStatusResponse.UpgradeStatus.NO_MIGRATION_NEEDED;
        });
        listener.onResponse((Object)new GetFeatureUpgradeStatusResponse(features, status));
    }

    static GetFeatureUpgradeStatusResponse.FeatureUpgradeStatus getFeatureUpgradeStatus(ProjectMetadata project, SystemIndices.Feature feature) {
        String featureName = feature.getName();
        PersistentTasksCustomMetadata.PersistentTask migrationTask = PersistentTasksCustomMetadata.getTaskWithId((ProjectMetadata)project, (String)"upgrade-system-indices");
        String currentFeature = Optional.ofNullable(migrationTask).map(task -> task.getState()).map(taskState -> ((SystemIndexMigrationTaskState)taskState).getCurrentFeature()).orElse(null);
        List<GetFeatureUpgradeStatusResponse.IndexInfo> indexInfos = TransportGetFeatureUpgradeStatusAction.getIndexInfos(project, feature);
        IndexVersion minimumVersion = indexInfos.stream().map(GetFeatureUpgradeStatusResponse.IndexInfo::getVersion).min(VersionId::compareTo).orElse(IndexVersion.current());
        GetFeatureUpgradeStatusResponse.UpgradeStatus initialStatus = featureName.equals(currentFeature) ? GetFeatureUpgradeStatusResponse.UpgradeStatus.IN_PROGRESS : (minimumVersion.before((VersionId)SystemIndices.NO_UPGRADE_REQUIRED_INDEX_VERSION) ? GetFeatureUpgradeStatusResponse.UpgradeStatus.MIGRATION_NEEDED : GetFeatureUpgradeStatusResponse.UpgradeStatus.NO_MIGRATION_NEEDED);
        GetFeatureUpgradeStatusResponse.UpgradeStatus status = indexInfos.stream().filter(idxInfo -> idxInfo.getException() != null).findFirst().map(idxInfo -> GetFeatureUpgradeStatusResponse.UpgradeStatus.ERROR).map(idxStatus -> GetFeatureUpgradeStatusResponse.UpgradeStatus.combine(idxStatus, initialStatus)).orElse(initialStatus);
        return new GetFeatureUpgradeStatusResponse.FeatureUpgradeStatus(featureName, minimumVersion, status, indexInfos);
    }

    static List<GetFeatureUpgradeStatusResponse.IndexInfo> getIndexInfos(ProjectMetadata project, SystemIndices.Feature feature) {
        SingleFeatureMigrationResult featureStatus = Optional.ofNullable((FeatureMigrationResults)project.custom("system_index_migration")).map(FeatureMigrationResults::getFeatureStatuses).map(results -> (SingleFeatureMigrationResult)results.get(feature.getName())).orElse(null);
        String failedResourceName = featureStatus == null ? null : featureStatus.getFailedResourceName();
        String failedFeatureUpgradedName = failedResourceName == null ? null : failedResourceName + SystemIndices.UPGRADED_INDEX_SUFFIX;
        Exception exception = featureStatus == null ? null : featureStatus.getException();
        Stream<GetFeatureUpgradeStatusResponse.IndexInfo> indexInfoStream = feature.getIndexDescriptors().stream().flatMap(descriptor -> descriptor.getMatchingIndices(project).stream()).sorted(String::compareTo).map(arg_0 -> ((ProjectMetadata)project).index(arg_0)).map(indexMetadata -> new GetFeatureUpgradeStatusResponse.IndexInfo(indexMetadata.getIndex().getName(), indexMetadata.getCreationVersion(), indexMetadata.getIndex().getName().equals(failedResourceName) || indexMetadata.getIndex().getName().equals(failedFeatureUpgradedName) ? exception : null));
        Stream dataStreamsIndexInfoStream = feature.getDataStreamDescriptors().stream().flatMap(descriptor -> {
            Exception dsException = descriptor.getDataStreamName().equals(failedResourceName) ? exception : null;
            return descriptor.getMatchingIndices(project).stream().sorted(String::compareTo).map(arg_0 -> ((ProjectMetadata)project).index(arg_0)).map(indexMetadata -> new GetFeatureUpgradeStatusResponse.IndexInfo(indexMetadata.getIndex().getName(), indexMetadata.getCreationVersion(), dsException));
        });
        return Stream.concat(indexInfoStream, dataStreamsIndexInfoStream).toList();
    }

    protected ClusterBlockException checkBlock(GetFeatureUpgradeStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

