/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class SessionUtils {
    private SessionUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Block[] fromPages(List<Attribute> schema, List<Page> pages, BlockFactory blockFactory) {
        Block[] blocks;
        int positionCount = pages.stream().mapToInt(Page::getPositionCount).sum();
        Block.Builder[] builders = new Block.Builder[schema.size()];
        try {
            for (int b = 0; b < builders.length; ++b) {
                builders[b] = PlannerUtils.toElementType(schema.get(b).dataType()).newBlockBuilder(positionCount, blockFactory);
            }
            for (Page p : pages) {
                for (int b = 0; b < builders.length; ++b) {
                    builders[b].copyFrom(p.getBlock(b), 0, p.getPositionCount());
                }
            }
            blocks = Block.Builder.buildAll((Block.Builder[])builders);
        }
        finally {
            Releasables.closeExpectNoException((Releasable[])builders);
        }
        return blocks;
    }

    public static long checkPagesBelowSize(List<Page> pages, ByteSizeValue maxSize, LongFunction<String> exceptionMessage) {
        long currentSize = pages.stream().mapToLong(Page::ramBytesUsedByBlocks).sum();
        if (currentSize > maxSize.getBytes()) {
            throw new IllegalArgumentException(exceptionMessage.apply(currentSize));
        }
        return currentSize;
    }

    public static List<Object> fromPage(List<Attribute> schema, Page page) {
        if (page.getPositionCount() != 1) {
            throw new IllegalArgumentException("expected single row");
        }
        ArrayList<Object> values = new ArrayList<Object>(schema.size());
        for (int i = 0; i < schema.size(); ++i) {
            values.add(BlockUtils.toJavaObject((Block)page.getBlock(i), (int)0));
        }
        return values;
    }
}

