/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.local;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;

public class ImmediateLocalSupplier
implements LocalSupplier {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LocalSupplier.class, "ImmediateSupplier", ImmediateLocalSupplier::new);
    final Block[] blocks;

    ImmediateLocalSupplier(Block[] blocks) {
        this.blocks = blocks;
    }

    ImmediateLocalSupplier(StreamInput in) throws IOException {
        this(((PlanStreamInput)in).readCachedBlockArray());
    }

    @Override
    public Block[] get() {
        return this.blocks;
    }

    public String toString() {
        return Arrays.toString(this.blocks);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray((o, v) -> ((PlanStreamOutput)o).writeCachedBlock((Block)v), (Object[])this.blocks);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ImmediateLocalSupplier other = (ImmediateLocalSupplier)obj;
        return Arrays.equals(this.blocks, other.blocks);
    }

    public int hashCode() {
        return Arrays.hashCode(this.blocks);
    }

    public String getWriteableName() {
        return ImmediateLocalSupplier.ENTRY.name;
    }
}

