/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong;

public final class RoundToLong8Evaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(RoundToLong8Evaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final long p0;
    private final long p1;
    private final long p2;
    private final long p3;
    private final long p4;
    private final long p5;
    private final long p6;
    private final long p7;
    private final DriverContext driverContext;
    private Warnings warnings;

    public RoundToLong8Evaluator(Source source, EvalOperator.ExpressionEvaluator field, long p0, long p1, long p2, long p3, long p4, long p5, long p6, long p7, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        this.p4 = p4;
        this.p5 = p5;
        this.p6 = p6;
        this.p7 = p7;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock fieldBlock = (LongBlock)this.field.eval(page);){
            LongVector fieldVector = fieldBlock.asVector();
            if (fieldVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), fieldBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), fieldVector).asBlock();
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.field.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock fieldBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (fieldBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (fieldBlock.getValueCount(p) != 1) {
                    if (fieldBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                long field = fieldBlock.getLong(fieldBlock.getFirstValueIndex(p));
                result.appendLong(RoundToLong.process(field, this.p0, this.p1, this.p2, this.p3, this.p4, this.p5, this.p6, this.p7));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector fieldVector) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                long field = fieldVector.getLong(p);
                result.appendLong(p, RoundToLong.process(field, this.p0, this.p1, this.p2, this.p3, this.p4, this.p5, this.p6, this.p7));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "RoundToLong8Evaluator[field=" + String.valueOf(this.field) + ", p0=" + this.p0 + ", p1=" + this.p1 + ", p2=" + this.p2 + ", p3=" + this.p3 + ", p4=" + this.p4 + ", p5=" + this.p5 + ", p6=" + this.p6 + ", p7=" + this.p7 + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.field);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final long p0;
        private final long p1;
        private final long p2;
        private final long p3;
        private final long p4;
        private final long p5;
        private final long p6;
        private final long p7;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, long p0, long p1, long p2, long p3, long p4, long p5, long p6, long p7) {
            this.source = source;
            this.field = field;
            this.p0 = p0;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
            this.p5 = p5;
            this.p6 = p6;
            this.p7 = p7;
        }

        public RoundToLong8Evaluator get(DriverContext context) {
            return new RoundToLong8Evaluator(this.source, this.field.get(context), this.p0, this.p1, this.p2, this.p3, this.p4, this.p5, this.p6, this.p7, context);
        }

        public String toString() {
            return "RoundToLong8Evaluator[field=" + String.valueOf(this.field) + ", p0=" + this.p0 + ", p1=" + this.p1 + ", p2=" + this.p2 + ", p3=" + this.p3 + ", p4=" + this.p4 + ", p5=" + this.p5 + ", p6=" + this.p6 + ", p7=" + this.p7 + "]";
        }
    }
}

