/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AsyncOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.IsBlockedResult;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.lookup.RightChunkedLeftJoin;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.enrich.LookupFromIndexService;
import org.elasticsearch.xpack.esql.enrich.MatchConfig;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public final class LookupFromIndexOperator
extends AsyncOperator<OngoingJoin> {
    private final LookupFromIndexService lookupService;
    private final String sessionId;
    private final CancellableTask parentTask;
    private final String lookupIndexPattern;
    private final String lookupIndex;
    private final List<NamedExpression> loadFields;
    private final Source source;
    private long totalRows = 0L;
    private final List<MatchConfig> matchFields;
    private final PhysicalPlan rightPreJoinPlan;
    private final Expression joinOnConditions;
    private long emittedPages = 0L;
    private long emittedRows = 0L;
    private OngoingJoin ongoing = null;

    public LookupFromIndexOperator(List<MatchConfig> matchFields, String sessionId, DriverContext driverContext, CancellableTask parentTask, int maxOutstandingRequests, LookupFromIndexService lookupService, String lookupIndexPattern, String lookupIndex, List<NamedExpression> loadFields, Source source, PhysicalPlan rightPreJoinPlan, Expression joinOnConditions) {
        super(driverContext, lookupService.getThreadContext(), maxOutstandingRequests);
        this.matchFields = matchFields;
        this.sessionId = sessionId;
        this.parentTask = parentTask;
        this.lookupService = lookupService;
        this.lookupIndexPattern = lookupIndexPattern;
        this.lookupIndex = lookupIndex;
        this.loadFields = loadFields;
        this.source = source;
        this.rightPreJoinPlan = rightPreJoinPlan;
        this.joinOnConditions = joinOnConditions;
    }

    protected void performAsync(Page inputPage, ActionListener<OngoingJoin> listener) {
        ArrayList<MatchConfig> newMatchFields = new ArrayList<MatchConfig>();
        List<MatchConfig> uniqueMatchFields = this.uniqueMatchFieldsByName(this.matchFields);
        Block[] inputBlockArray = new Block[uniqueMatchFields.size()];
        for (int i = 0; i < uniqueMatchFields.size(); ++i) {
            Block inputBlock;
            MatchConfig matchField = uniqueMatchFields.get(i);
            int inputChannel = matchField.channel();
            inputBlockArray[i] = inputBlock = inputPage.getBlock(inputChannel);
            newMatchFields.add(new MatchConfig(matchField.fieldName(), i, matchField.type()));
        }
        this.totalRows += (long)inputPage.getBlock(0).getTotalValueCount();
        LookupFromIndexService.Request request = new LookupFromIndexService.Request(this.sessionId, this.lookupIndex, this.lookupIndexPattern, newMatchFields, new Page(inputBlockArray), this.loadFields, this.source, this.rightPreJoinPlan, this.joinOnConditions);
        this.lookupService.lookupAsync(request, this.parentTask, (ActionListener<List<Page>>)listener.map(pages -> new OngoingJoin(new RightChunkedLeftJoin(inputPage, this.loadFields.size()), pages.iterator())));
    }

    private List<MatchConfig> uniqueMatchFieldsByName(List<MatchConfig> matchFields) {
        if (this.joinOnConditions == null) {
            return matchFields;
        }
        ArrayList<MatchConfig> uniqueFields = new ArrayList<MatchConfig>();
        HashSet<String> seenFieldNames = new HashSet<String>();
        for (MatchConfig matchField : matchFields) {
            if (!seenFieldNames.add(matchField.fieldName())) continue;
            uniqueFields.add(matchField);
        }
        return uniqueFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getOutput() {
        if (this.ongoing == null) {
            this.ongoing = (OngoingJoin)this.fetchFromBuffer();
            if (this.ongoing == null) {
                return null;
            }
        }
        if (this.ongoing.itr.hasNext()) {
            Page right = this.ongoing.itr.next();
            ++this.emittedPages;
            try {
                Page joinedPage = this.ongoing.join.join(right);
                this.emittedRows += (long)joinedPage.getPositionCount();
                Page page = joinedPage;
                return page;
            }
            finally {
                right.releaseBlocks();
            }
        }
        Optional remaining = this.ongoing.join.noMoreRightHandPages();
        this.ongoing.close();
        this.ongoing = null;
        if (remaining.isEmpty()) {
            return null;
        }
        ++this.emittedPages;
        this.emittedRows += (long)((Page)remaining.get()).getPositionCount();
        return (Page)remaining.get();
    }

    protected void releaseFetchedOnAnyThread(OngoingJoin ongoingJoin) {
        ongoingJoin.releaseOnAnyThread();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LookupOperator[index=").append(this.lookupIndex).append(" load_fields=").append(this.loadFields);
        for (MatchConfig matchField : this.matchFields) {
            stringBuilder.append(" input_type=").append(matchField.type()).append(" match_field=").append(matchField.fieldName()).append(" inputChannel=").append(matchField.channel());
        }
        stringBuilder.append(" right_pre_join_plan=").append(this.rightPreJoinPlan == null ? "null" : this.rightPreJoinPlan.toString());
        stringBuilder.append(" join_on_expression=").append(this.joinOnConditions == null ? "null" : this.joinOnConditions.toString());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean isFinished() {
        return this.ongoing == null && super.isFinished();
    }

    public IsBlockedResult isBlocked() {
        if (this.ongoing != null) {
            return NOT_BLOCKED;
        }
        return super.isBlocked();
    }

    protected void doClose() {
        Releasables.close((Releasable)this.ongoing);
    }

    protected Operator.Status status(long receivedPages, long completedPages, long processNanos) {
        return new Status(receivedPages, completedPages, processNanos, this.totalRows, this.emittedPages, this.emittedRows);
    }

    protected record OngoingJoin(RightChunkedLeftJoin join, Iterator<Page> itr) implements Releasable
    {
        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.join, Releasables.wrap(() -> Iterators.map(this.itr, page -> () -> ((Page)page).releaseBlocks()))});
        }

        public void releaseOnAnyThread() {
            Releasable[] releasableArray = new Releasable[2];
            releasableArray[0] = () -> ((RightChunkedLeftJoin)this.join).releaseOnAnyThread();
            releasableArray[1] = Releasables.wrap(() -> Iterators.map(this.itr, page -> () -> LookupFromIndexOperator.releasePageOnAnyThread((Page)page)));
            Releasables.close((Releasable[])releasableArray);
        }
    }

    public static class Status
    extends AsyncOperator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "lookup", Status::new);
        private static final TransportVersion ESQL_LOOKUP_OPERATOR_EMITTED_ROWS = TransportVersion.fromName((String)"esql_lookup_operator_emitted_rows");
        private final long totalRows;
        private final long emittedPages;
        private final long emittedRows;

        Status(long receivedPages, long completedPages, long processNanos, long totalRows, long emittedPages, long emittedRows) {
            super(receivedPages, completedPages, processNanos);
            this.totalRows = totalRows;
            this.emittedPages = emittedPages;
            this.emittedRows = emittedRows;
        }

        Status(StreamInput in) throws IOException {
            super(in);
            this.totalRows = in.readVLong();
            this.emittedPages = in.readVLong();
            this.emittedRows = in.getTransportVersion().supports(ESQL_LOOKUP_OPERATOR_EMITTED_ROWS) ? in.readVLong() : 0L;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.totalRows);
            out.writeVLong(this.emittedPages);
            if (out.getTransportVersion().supports(ESQL_LOOKUP_OPERATOR_EMITTED_ROWS)) {
                out.writeVLong(this.emittedRows);
            }
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public long emittedPages() {
            return this.emittedPages;
        }

        public long emittedRows() {
            return this.emittedPages;
        }

        public long totalRows() {
            return this.totalRows;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            super.innerToXContent(builder);
            builder.field("pages_emitted", this.emittedPages);
            builder.field("rows_emitted", this.emittedRows);
            builder.field("total_rows", this.totalRows);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass() || !super.equals(o)) {
                return false;
            }
            Status status = (Status)((Object)o);
            return this.totalRows == status.totalRows && this.emittedPages == status.emittedPages && this.emittedRows == status.emittedRows;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.totalRows, this.emittedPages, this.emittedRows);
        }
    }

    public record Factory(List<MatchConfig> matchFields, String sessionId, CancellableTask parentTask, int maxOutstandingRequests, Function<DriverContext, LookupFromIndexService> lookupService, String lookupIndexPattern, String lookupIndex, List<NamedExpression> loadFields, Source source, PhysicalPlan rightPreJoinPlan, Expression joinOnConditions) implements Operator.OperatorFactory
    {
        public String describe() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("LookupOperator[index=").append(this.lookupIndex).append(" load_fields=").append(this.loadFields);
            for (MatchConfig matchField : this.matchFields) {
                stringBuilder.append(" input_type=").append(matchField.type()).append(" match_field=").append(matchField.fieldName()).append(" inputChannel=").append(matchField.channel());
            }
            stringBuilder.append(" right_pre_join_plan=").append(this.rightPreJoinPlan == null ? "null" : this.rightPreJoinPlan.toString());
            stringBuilder.append(" join_on_expression=").append(this.joinOnConditions == null ? "null" : this.joinOnConditions.toString());
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        public Operator get(DriverContext driverContext) {
            return new LookupFromIndexOperator(this.matchFields, this.sessionId, driverContext, this.parentTask, this.maxOutstandingRequests, this.lookupService.apply(driverContext), this.lookupIndexPattern, this.lookupIndex, this.loadFields, this.source, this.rightPreJoinPlan, this.joinOnConditions);
        }
    }
}

