/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.unboundidds.controls.UndeleteRequestControl;
import com.unboundid.ldap.sdk.unboundidds.tools.ParallelUpdate;
import com.unboundid.ldap.sdk.unboundidds.tools.ParallelUpdateOperationQueue;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;

final class ParallelUpdateOperationThread
extends Thread {
    @NotNull
    private static final String ATTR_UNDELETE_FROM_DN = "ds-undelete-from-dn";
    private final boolean allowUndelete;
    @NotNull
    private final Control[] addControls;
    @NotNull
    private final Control[] deleteControls;
    @NotNull
    private final Control[] modifyControls;
    @NotNull
    private final Control[] modifyDNControls;
    @Nullable
    private final FixedRateBarrier rateLimiter;
    @NotNull
    private final LDAPConnectionPool connectionPool;
    @NotNull
    private final ParallelUpdateOperationQueue opQueue;
    @NotNull
    private final ParallelUpdate parallelUpdate;

    ParallelUpdateOperationThread(@NotNull ParallelUpdate parallelUpdate, @NotNull LDAPConnectionPool connectionPool, @NotNull ParallelUpdateOperationQueue opQueue, int threadNumber, @Nullable FixedRateBarrier rateLimiter, @NotNull Control[] addControls, @NotNull Control[] deleteControls, @NotNull Control[] modifyControls, @NotNull Control[] modifyDNControls, boolean allowUndelete) {
        this.setName("Parallel Update Operation Thread " + threadNumber);
        this.parallelUpdate = parallelUpdate;
        this.connectionPool = connectionPool;
        this.opQueue = opQueue;
        this.rateLimiter = rateLimiter;
        this.addControls = addControls;
        this.deleteControls = deleteControls;
        this.modifyControls = modifyControls;
        this.modifyDNControls = modifyDNControls;
        this.allowUndelete = allowUndelete;
    }

    @Override
    public void run() {
        LDIFChangeRecord r = this.opQueue.getChangeRecord(new DN[0]);
        UndeleteRequestControl undeleteRequestControl = new UndeleteRequestControl();
        while (r != null) {
            if (this.rateLimiter != null) {
                this.rateLimiter.await();
            }
            DN parsedDN = null;
            DN parsedNewDN = null;
            long startTime = System.currentTimeMillis();
            try {
                parsedDN = r.getParsedDN();
                if (r instanceof LDIFAddChangeRecord) {
                    AddRequest addRequest = ((LDIFAddChangeRecord)r).toAddRequest();
                    addRequest.addControls(this.addControls);
                    if (this.allowUndelete && addRequest.hasAttribute(ATTR_UNDELETE_FROM_DN)) {
                        addRequest.addControl(undeleteRequestControl);
                    }
                    this.connectionPool.add(addRequest);
                    this.parallelUpdate.opCompletedSuccessfully(r, System.currentTimeMillis() - startTime);
                } else if (r instanceof LDIFDeleteChangeRecord) {
                    DeleteRequest deleteRequest = ((LDIFDeleteChangeRecord)r).toDeleteRequest();
                    deleteRequest.addControls(this.deleteControls);
                    this.connectionPool.delete(deleteRequest);
                    this.parallelUpdate.opCompletedSuccessfully(r, System.currentTimeMillis() - startTime);
                } else if (r instanceof LDIFModifyChangeRecord) {
                    ModifyRequest modifyRequest = ((LDIFModifyChangeRecord)r).toModifyRequest();
                    modifyRequest.addControls(this.modifyControls);
                    this.connectionPool.modify(modifyRequest);
                    this.parallelUpdate.opCompletedSuccessfully(r, System.currentTimeMillis() - startTime);
                } else if (r instanceof LDIFModifyDNChangeRecord) {
                    LDIFModifyDNChangeRecord modifyDNChangeRecord = (LDIFModifyDNChangeRecord)r;
                    parsedNewDN = modifyDNChangeRecord.getNewDN();
                    ModifyDNRequest modifyDNRequest = modifyDNChangeRecord.toModifyDNRequest();
                    modifyDNRequest.addControls(this.modifyDNControls);
                    this.connectionPool.modifyDN(modifyDNRequest);
                    this.parallelUpdate.opCompletedSuccessfully(r, System.currentTimeMillis() - startTime);
                } else {
                    r.processChange(this.connectionPool);
                    this.parallelUpdate.opCompletedSuccessfully(r, System.currentTimeMillis() - startTime);
                }
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                this.parallelUpdate.opFailed(r, e, System.currentTimeMillis() - startTime);
            }
            if (parsedNewDN == null) {
                r = this.opQueue.getChangeRecord(parsedDN);
                continue;
            }
            r = this.opQueue.getChangeRecord(parsedDN, parsedNewDN);
        }
    }
}

