/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.ojalgo.array.SparseArray;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.ElementView1D;
import org.ojalgo.structure.RowView;

public final class RowsSupplier<N extends Comparable<N>>
implements Access2D<N>,
ElementsSupplier<N>,
Supplier<PhysicalStore<N>> {
    private final int myColumnsCount;
    private final PhysicalStore.Factory<N, ?> myFactory;
    private final List<SparseArray<N>> myRows = new ArrayList<SparseArray<N>>();

    RowsSupplier(PhysicalStore.Factory<N, ?> factory, int numberOfColumns) {
        this.myColumnsCount = numberOfColumns;
        this.myFactory = factory;
    }

    public SparseArray<N> addRow() {
        return this.addRow((SparseArray<N>)((SparseArray.SparseFactory)SparseArray.factory(this.myFactory.array()).limit(this.myColumnsCount)).make());
    }

    public void addRows(int numberToAdd) {
        SparseArray.SparseFactory factory = (SparseArray.SparseFactory)SparseArray.factory(this.myFactory.array()).limit(this.myColumnsCount);
        for (int i = 0; i < numberToAdd; ++i) {
            this.myRows.add((SparseArray<N>)factory.make());
        }
    }

    @Override
    public long countColumns() {
        return this.myColumnsCount;
    }

    @Override
    public long countRows() {
        return this.myRows.size();
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myRows.get((int)row).doubleValue(col);
    }

    @Override
    public PhysicalStore<N> get() {
        return (PhysicalStore)this.collect(this.myFactory);
    }

    @Override
    public N get(long row, long col) {
        return this.myRows.get((int)row).get(col);
    }

    public SparseArray<N> getRow(int index) {
        return this.myRows.get(index);
    }

    public PhysicalStore.Factory<N, ?> physical() {
        return this.myFactory;
    }

    public SparseArray<N> removeRow(int index) {
        return this.myRows.remove(index);
    }

    @Override
    public RowView<N> rows() {
        return new ItemView(this);
    }

    public RowsSupplier<N> selectRows(int[] indices) {
        RowsSupplier<N> retVal = new RowsSupplier<N>(this.myFactory, this.myColumnsCount);
        for (int i = 0; i < indices.length; ++i) {
            retVal.addRow(this.getRow(indices[i]));
        }
        return retVal;
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        receiver.reset();
        int limit = this.myRows.size();
        for (int i = 0; i < limit; ++i) {
            this.myRows.get(i).supplyNonZerosTo(receiver.regionByRows(i));
        }
    }

    public String toString() {
        return Access2D.toString(this);
    }

    SparseArray<N> addRow(SparseArray<N> rowToAdd) {
        if (this.myRows.add(rowToAdd)) {
            return rowToAdd;
        }
        return null;
    }

    static final class ItemView<N extends Comparable<N>>
    extends RowView<N> {
        private final RowsSupplier<N> mySupplier;

        ItemView(RowsSupplier<N> access) {
            super(access);
            this.mySupplier = access;
        }

        @Override
        public ElementView1D<N, ?> elements() {
            return this.getCurrent().elements();
        }

        @Override
        public ElementView1D<N, ?> nonzeros() {
            return this.getCurrent().nonzeros();
        }

        private SparseArray<N> getCurrent() {
            return this.mySupplier.getRow(Math.toIntExact(this.row()));
        }
    }
}

