/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;

public final class SubstituteBackwards
implements ArrayOperation {
    public static int THRESHOLD = 64;

    public static void invoke(double[] data, int structure, int first, int limit, Access2D<?> body, boolean unitDiagonal, boolean conjugated, boolean hermitian) {
        int diagDim = MissingMath.toMinIntExact(body.countRows(), body.countColumns());
        double[] bodyRow = new double[diagDim];
        int firstRow = hermitian ? first : 0;
        for (int i = diagDim - 1; i >= firstRow; --i) {
            for (int j = i; j < diagDim; ++j) {
                bodyRow[j] = conjugated ? body.doubleValue(j, i) : body.doubleValue(i, j);
            }
            int columnLimit = hermitian ? Math.min(i + 1, limit) : limit;
            for (int s = first; s < columnLimit; ++s) {
                int colBaseIndex = s * structure;
                double tmpVal = PrimitiveMath.ZERO;
                for (int j = i + 1; j < diagDim; ++j) {
                    tmpVal += bodyRow[j] * data[j + colBaseIndex];
                }
                tmpVal = data[i + colBaseIndex] - tmpVal;
                if (!unitDiagonal) {
                    tmpVal /= bodyRow[i];
                }
                data[i + colBaseIndex] = tmpVal;
            }
        }
    }

    public static void invoke(double[][] data, Access2D<?> body, boolean unitDiagonal, boolean conjugated, boolean hermitian) {
        int limit = data[0].length;
        int diagDim = MissingMath.toMinIntExact(body.countRows(), body.countColumns());
        double[] bodyRow = new double[diagDim];
        for (int i = diagDim - 1; i >= 0; --i) {
            for (int j = i; j < diagDim; ++j) {
                bodyRow[j] = conjugated ? body.doubleValue(j, i) : body.doubleValue(i, j);
            }
            int columnLimit = hermitian ? Math.min(i + 1, limit) : limit;
            for (int s = 0; s < columnLimit; ++s) {
                double tmpVal = PrimitiveMath.ZERO;
                for (int j = i + 1; j < diagDim; ++j) {
                    tmpVal += bodyRow[j] * data[j][s];
                }
                tmpVal = data[i][s] - tmpVal;
                if (!unitDiagonal) {
                    tmpVal /= bodyRow[i];
                }
                data[i][s] = tmpVal;
            }
        }
    }

    public static void invoke(float[] data, int structure, int first, int limit, Access2D<?> body, boolean unitDiagonal, boolean conjugated, boolean hermitian) {
        int diagDim = MissingMath.toMinIntExact(body.countRows(), body.countColumns());
        float[] bodyRow = new float[diagDim];
        int firstRow = hermitian ? first : 0;
        for (int i = diagDim - 1; i >= firstRow; --i) {
            for (int j = i; j < diagDim; ++j) {
                bodyRow[j] = conjugated ? body.floatValue(j, i) : body.floatValue(i, j);
            }
            int columnLimit = hermitian ? Math.min(i + 1, limit) : limit;
            for (int s = first; s < columnLimit; ++s) {
                int colBaseIndex = s * structure;
                float tmpVal = 0.0f;
                for (int j = i + 1; j < diagDim; ++j) {
                    tmpVal += bodyRow[j] * data[j + colBaseIndex];
                }
                tmpVal = data[i + colBaseIndex] - tmpVal;
                if (!unitDiagonal) {
                    tmpVal /= bodyRow[i];
                }
                data[i + colBaseIndex] = tmpVal;
            }
        }
    }

    public static <N extends Scalar<N>> void invoke(N[] data, int structure, int first, int limit, Access2D<N> body, boolean unitDiagonal, boolean conjugated, boolean hermitian, Scalar.Factory<N> scalar) {
        int diagDim = (int)Math.min(body.countRows(), body.countColumns());
        Scalar[] bodyRow = (Scalar[])scalar.newArrayInstance(diagDim);
        int firstRow = hermitian ? first : 0;
        for (int i = diagDim - 1; i >= firstRow; --i) {
            for (int j = i; j < diagDim; ++j) {
                bodyRow[j] = conjugated ? (Scalar)((Scalar)((Scalar)body.get(j, i)).conjugate()).get() : (Scalar)body.get(i, j);
            }
            int columnLimit = hermitian ? Math.min(i + 1, limit) : limit;
            for (int s = first; s < columnLimit; ++s) {
                int colBaseIndex = s * structure;
                Scalar tmpVal = scalar.zero();
                for (int j = i + 1; j < diagDim; ++j) {
                    tmpVal = tmpVal.add((Scalar)bodyRow[j].multiply(data[j + colBaseIndex]));
                }
                tmpVal = data[i + colBaseIndex].subtract(tmpVal);
                if (!unitDiagonal) {
                    tmpVal = tmpVal.divide(bodyRow[i]);
                }
                data[i + colBaseIndex] = (Scalar)tmpVal.get();
            }
        }
    }
}

