/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.ScalarArray;
import org.ojalgo.function.ComplexFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.ComplexAggregator;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;

public class ComplexArray
extends ScalarArray<ComplexNumber> {
    public static final DenseArray.Factory<ComplexNumber> FACTORY = new DenseArray.Factory<ComplexNumber>(){

        @Override
        public AggregatorSet<ComplexNumber> aggregator() {
            return ComplexAggregator.getSet();
        }

        @Override
        public FunctionSet<ComplexNumber> function() {
            return ComplexFunction.getSet();
        }

        @Override
        public Scalar.Factory<ComplexNumber> scalar() {
            return ComplexNumber.FACTORY;
        }

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        PlainArray<ComplexNumber> makeDenseArray(long size) {
            return ComplexArray.make((int)size);
        }
    };
    static final long ELEMENT_SIZE = MemoryEstimator.estimateObject(ComplexNumber.class);

    public static final ComplexArray make(int size) {
        return new ComplexArray(size);
    }

    public static final ComplexArray wrap(ComplexNumber ... data) {
        return new ComplexArray(data);
    }

    protected ComplexArray(ComplexNumber[] data) {
        super(FACTORY, (Scalar[])data);
    }

    protected ComplexArray(int size) {
        super(FACTORY, size);
    }
}

