/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.ArrayAnyD;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.operation.AMAX;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.machine.JavaType;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.StructureAnyD;
import org.ojalgo.type.NumberDefinition;

public abstract class BufferArray
extends PlainArray<Double> {
    public static final DenseArray.Factory<Double> DIRECT32 = new DenseArray.Factory<Double>(){

        @Override
        public AggregatorSet<Double> aggregator() {
            return PrimitiveAggregator.getSet();
        }

        @Override
        public FunctionSet<Double> function() {
            return PrimitiveFunction.getSet();
        }

        @Override
        public Scalar.Factory<Double> scalar() {
            return PrimitiveScalar.FACTORY;
        }

        @Override
        long getCapacityLimit() {
            return 0x7FFFFFF7L / FLOAT_ELEMENT_SIZE;
        }

        @Override
        long getElementSize() {
            return FLOAT_ELEMENT_SIZE;
        }

        @Override
        DenseArray<Double> makeDenseArray(long size) {
            int tmpSize = (int)size;
            ByteBuffer tmpAllocateDirect = ByteBuffer.allocateDirect(tmpSize * 4);
            return new FloatBufferArray(tmpAllocateDirect.asFloatBuffer(), null);
        }
    };
    public static final DenseArray.Factory<Double> DIRECT64 = new DenseArray.Factory<Double>(){

        @Override
        public AggregatorSet<Double> aggregator() {
            return PrimitiveAggregator.getSet();
        }

        @Override
        public FunctionSet<Double> function() {
            return PrimitiveFunction.getSet();
        }

        @Override
        public Scalar.Factory<Double> scalar() {
            return PrimitiveScalar.FACTORY;
        }

        @Override
        long getCapacityLimit() {
            return 0x7FFFFFF7L / DOUBLE_ELEMENT_SIZE;
        }

        @Override
        long getElementSize() {
            return DOUBLE_ELEMENT_SIZE;
        }

        @Override
        DenseArray<Double> makeDenseArray(long size) {
            int tmpSize = (int)size;
            ByteBuffer tmpAllocateDirect = ByteBuffer.allocateDirect(tmpSize * 8);
            return new DoubleBufferArray(tmpAllocateDirect.asDoubleBuffer(), null);
        }
    };
    static final long DOUBLE_ELEMENT_SIZE = JavaType.DOUBLE.memory();
    static final long FLOAT_ELEMENT_SIZE = JavaType.FLOAT.memory();
    private final Buffer myBuffer;
    private final RandomAccessFile myFile;

    public static Array1D<Double> make(File file, long count) {
        return BufferArray.create(file, count).wrapInArray1D();
    }

    public static ArrayAnyD<Double> make(File file, long ... structure) {
        return BufferArray.create(file, structure).wrapInArrayAnyD(structure);
    }

    public static Array2D<Double> make(File file, long rows, long columns) {
        return BufferArray.create(file, rows, columns).wrapInArray2D(rows);
    }

    public static BufferArray make(int capacity) {
        return new DoubleBufferArray(DoubleBuffer.allocate(capacity), null);
    }

    public static BufferArray wrap(DoubleBuffer data) {
        return new DoubleBufferArray(data, null);
    }

    public static BufferArray wrap(FloatBuffer data) {
        return new FloatBufferArray(data, null);
    }

    private static BasicArray<Double> create(File file, long ... structure) {
        long tmpCount = StructureAnyD.count(structure);
        DoubleBuffer tmpDoubleBuffer = null;
        try {
            final RandomAccessFile tmpRandomAccessFile = new RandomAccessFile(file, "rw");
            final FileChannel tmpFileChannel = tmpRandomAccessFile.getChannel();
            long tmpSize = DOUBLE_ELEMENT_SIZE * tmpCount;
            if (tmpCount <= 256L) {
                MappedByteBuffer tmpMappedByteBuffer = tmpFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, tmpSize);
                tmpMappedByteBuffer.order(ByteOrder.nativeOrder());
                tmpDoubleBuffer = tmpMappedByteBuffer.asDoubleBuffer();
                return new DoubleBufferArray(tmpDoubleBuffer, tmpRandomAccessFile);
            }
            DenseArray.Factory<Double> tmpFactory = new DenseArray.Factory<Double>(){
                long offset = 0L;

                @Override
                public AggregatorSet<Double> aggregator() {
                    return PrimitiveAggregator.getSet();
                }

                @Override
                public FunctionSet<Double> function() {
                    return PrimitiveFunction.getSet();
                }

                @Override
                public Scalar.Factory<Double> scalar() {
                    return PrimitiveScalar.FACTORY;
                }

                @Override
                long getElementSize() {
                    return DOUBLE_ELEMENT_SIZE;
                }

                @Override
                PlainArray<Double> makeDenseArray(long size) {
                    long tmpSize2 = size * DOUBLE_ELEMENT_SIZE;
                    try {
                        MappedByteBuffer tmpMap = tmpFileChannel.map(FileChannel.MapMode.READ_WRITE, this.offset, tmpSize2);
                        tmpMap.order(ByteOrder.nativeOrder());
                        DoubleBufferArray doubleBufferArray = new DoubleBufferArray(tmpMap.asDoubleBuffer(), tmpRandomAccessFile);
                        return doubleBufferArray;
                    }
                    catch (IOException exception) {
                        throw new RuntimeException(exception);
                    }
                    finally {
                        this.offset += tmpSize2;
                    }
                }
            };
            return tmpFactory.makeSegmented(structure);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected static void fill(BufferArray data, Access1D<?> value) {
        int tmpLimit = (int)Math.min(data.count(), value.count());
        for (int i = 0; i < tmpLimit; ++i) {
            data.set(i, value.doubleValue(i));
        }
    }

    protected static void fill(BufferArray data, int first, int limit, int step, double value) {
        for (int i = first; i < limit; i += step) {
            data.set(i, value);
        }
    }

    protected static void fill(BufferArray data, int first, int limit, int step, NullaryFunction<?> supplier) {
        for (int i = first; i < limit; i += step) {
            data.set(i, supplier.doubleValue());
        }
    }

    protected static void invoke(BufferArray data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        for (int i = first; i < limit; i += step) {
            data.set(i, (Comparable<?>)function.invoke(left.get(i), right.get(i)));
        }
    }

    protected static void invoke(BufferArray data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, double right) {
        for (int i = first; i < limit; i += step) {
            data.set(i, function.invoke(left.doubleValue(i), right));
        }
    }

    protected static void invoke(BufferArray data, int first, int limit, int step, Access1D<Double> value, ParameterFunction<Double> function, int aParam) {
        for (int i = first; i < limit; i += step) {
            data.set(i, function.invoke(value.doubleValue(i), aParam));
        }
    }

    protected static void invoke(BufferArray data, int first, int limit, int step, Access1D<Double> value, UnaryFunction<Double> function) {
        for (int i = first; i < limit; i += step) {
            data.set(i, function.invoke(value.doubleValue(i)));
        }
    }

    protected static void invoke(BufferArray data, int first, int limit, int step, double left, BinaryFunction<Double> function, Access1D<Double> right) {
        for (int i = first; i < limit; i += step) {
            data.set(i, function.invoke(left, right.doubleValue(i)));
        }
    }

    protected static void invoke(BufferArray data, int first, int limit, int step, VoidFunction<Double> visitor) {
        for (int i = first; i < limit; i += step) {
            visitor.invoke(data.get(i));
        }
    }

    BufferArray(DenseArray.Factory<Double> factory, Buffer buffer, RandomAccessFile file) {
        super(factory, buffer.capacity());
        this.myBuffer = buffer;
        this.myFile = file;
    }

    public void close() {
        if (this.myFile != null) {
            try {
                this.myFile.close();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void reset() {
        this.fillAll(PrimitiveMath.ZERO);
        this.myBuffer.clear();
    }

    @Override
    public int size() {
        return this.myBuffer.capacity();
    }

    @Override
    protected void add(int index, Comparable<?> addend) {
        this.set(index, this.doubleValue(index) + NumberDefinition.doubleValue(addend));
    }

    @Override
    protected void add(int index, double addend) {
        this.set(index, this.doubleValue(index) + addend);
    }

    @Override
    protected void add(int index, float addend) {
        this.set(index, this.floatValue(index) + addend);
    }

    @Override
    protected void exchange(int firstA, int firstB, int step, int count) {
        int tmpIndexA = firstA;
        int tmpIndexB = firstB;
        for (int i = 0; i < count; ++i) {
            double tmpVal = this.doubleValue(tmpIndexA);
            this.set(tmpIndexA, this.doubleValue(tmpIndexB));
            this.set(tmpIndexB, tmpVal);
            tmpIndexA += step;
            tmpIndexB += step;
        }
    }

    @Override
    protected void fill(int first, int limit, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        BufferArray.invoke(this, first, limit, 1, left, function, right);
    }

    @Override
    protected void fill(int first, int limit, Access1D<Double> left, BinaryFunction<Double> function, Double right) {
        BufferArray.invoke(this, first, limit, 1, left, function, right);
    }

    @Override
    protected void fill(int first, int limit, Double left, BinaryFunction<Double> function, Access1D<Double> right) {
        BufferArray.invoke(this, first, limit, 1, left, function, right);
    }

    @Override
    protected void fill(int first, int limit, int step, Double value) {
        BufferArray.fill(this, first, limit, step, value);
    }

    @Override
    protected void fill(int first, int limit, int step, NullaryFunction<?> supplier) {
        BufferArray.fill(this, first, limit, step, supplier);
    }

    @Override
    protected void fillOne(int index, Access1D<?> values, long valueIndex) {
        this.set(index, values.doubleValue(valueIndex));
    }

    @Override
    protected void fillOne(int index, Double value) {
        this.set(index, (Comparable<?>)value);
    }

    @Override
    protected Double get(int index) {
        return this.doubleValue(index);
    }

    @Override
    protected int indexOfLargest(int first, int limit, int step) {
        return AMAX.invoke(this, first, limit, step);
    }

    @Override
    protected boolean isAbsolute(int index) {
        return PrimitiveScalar.isAbsolute(this.doubleValue(index));
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.doubleValue(index));
    }

    @Override
    protected void modify(int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function) {
        BufferArray.invoke(this, first, limit, step, left, function, (Access1D<Double>)this);
    }

    @Override
    protected void modify(int first, int limit, int step, BinaryFunction<Double> function, Access1D<Double> right) {
        BufferArray.invoke(this, first, limit, step, (Access1D<Double>)this, function, right);
    }

    @Override
    protected void modify(int first, int limit, int step, BinaryFunction<Double> function, Double right) {
        BufferArray.invoke(this, first, limit, step, (Access1D<Double>)this, function, right);
    }

    @Override
    protected void modify(int first, int limit, int step, Double left, BinaryFunction<Double> function) {
        BufferArray.invoke(this, first, limit, step, left, function, (Access1D<Double>)this);
    }

    @Override
    protected void modify(int first, int limit, int step, ParameterFunction<Double> function, int parameter) {
        BufferArray.invoke(this, first, limit, step, (Access1D<Double>)this, function, parameter);
    }

    @Override
    protected void modify(int first, int limit, int step, UnaryFunction<Double> function) {
        BufferArray.invoke(this, first, limit, step, this, function);
    }

    @Override
    protected void modifyOne(int index, UnaryFunction<Double> modifier) {
        this.set(index, modifier.invoke(this.doubleValue(index)));
    }

    @Override
    protected int searchAscending(Double number) {
        return -1;
    }

    @Override
    protected void set(int index, Comparable<?> value) {
        this.set(index, NumberDefinition.doubleValue(value));
    }

    @Override
    protected void sortAscending() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    @Override
    protected void sortDescending() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    @Override
    protected void visit(int first, int limit, int step, VoidFunction<Double> visitor) {
        BufferArray.invoke(this, first, limit, step, visitor);
    }

    @Override
    protected void visitOne(int index, VoidFunction<Double> visitor) {
        visitor.invoke(this.doubleValue(index));
    }

    @Override
    boolean isPrimitive() {
        return true;
    }

    @Override
    void modify(long extIndex, int intIndex, Access1D<Double> left, BinaryFunction<Double> function) {
        this.set(intIndex, function.invoke(left.doubleValue(extIndex), this.doubleValue(intIndex)));
    }

    @Override
    void modify(long extIndex, int intIndex, BinaryFunction<Double> function, Access1D<Double> right) {
        this.set(intIndex, function.invoke(this.doubleValue(intIndex), right.doubleValue(extIndex)));
    }

    @Override
    void modify(long extIndex, int intIndex, UnaryFunction<Double> function) {
        this.set(intIndex, function.invoke(this.doubleValue(intIndex)));
    }

    static final class FloatBufferArray
    extends BufferArray {
        private final FloatBuffer myFloatBuffer;

        FloatBufferArray(FloatBuffer buffer, RandomAccessFile file) {
            super(DIRECT32, buffer, file);
            this.myFloatBuffer = buffer;
        }

        @Override
        public void supplyTo(Mutate1D receiver) {
            int limit = Math.min(this.size(), receiver.size());
            for (int i = 0; i < limit; ++i) {
                receiver.set((long)i, this.doubleValue(i));
            }
        }

        @Override
        protected double doubleValue(int index) {
            return this.myFloatBuffer.get(index);
        }

        @Override
        protected void fillOne(int index, NullaryFunction<?> supplier) {
            this.myFloatBuffer.put(index, supplier.floatValue());
        }

        @Override
        protected float floatValue(int index) {
            return this.myFloatBuffer.get(index);
        }

        @Override
        protected void set(int index, double value) {
            this.myFloatBuffer.put(index, (float)value);
        }

        @Override
        protected void set(int index, float value) {
            this.myFloatBuffer.put(index, value);
        }
    }

    static final class DoubleBufferArray
    extends BufferArray {
        private final DoubleBuffer myDoubleBuffer;

        DoubleBufferArray(DoubleBuffer buffer, RandomAccessFile file) {
            super(DIRECT64, buffer, file);
            this.myDoubleBuffer = buffer;
        }

        @Override
        public void supplyTo(Mutate1D receiver) {
            int limit = Math.min(this.size(), receiver.size());
            for (int i = 0; i < limit; ++i) {
                receiver.set((long)i, this.doubleValue(i));
            }
        }

        @Override
        protected double doubleValue(int index) {
            return this.myDoubleBuffer.get(index);
        }

        @Override
        protected void fillOne(int index, NullaryFunction<?> supplier) {
            this.myDoubleBuffer.put(index, supplier.doubleValue());
        }

        @Override
        protected float floatValue(int index) {
            return (float)this.myDoubleBuffer.get(index);
        }

        @Override
        protected void set(int index, double value) {
            this.myDoubleBuffer.put(index, value);
        }

        @Override
        protected void set(int index, float value) {
            this.myDoubleBuffer.put(index, value);
        }
    }
}

