/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.h3;

import org.elasticsearch.h3.BaseCells;
import org.elasticsearch.h3.CellBoundary;
import org.elasticsearch.h3.CoordIJK;
import org.elasticsearch.h3.H3Index;
import org.elasticsearch.h3.LatLng;
import org.elasticsearch.h3.Vec2d;

final class FaceIJK {
    private static final int IJ = 1;
    private static final int KI = 2;
    private static final int JK = 3;
    private static final int[] maxDimByCIIres = new int[]{2, -1, 14, -1, 98, -1, 686, -1, 4802, -1, 33614, -1, 235298, -1, 1647086, -1, 11529602};
    private static final Vec2d[][] maxDimByCIIVec2d = new Vec2d[maxDimByCIIres.length][3];
    private static final int[] unitScaleByCIIres;
    private static final int[][] adjacentFaceDir;
    private static final int MAX_FACE_COORD = 2;
    private static final FaceOrientIJK[][] faceNeighbors;
    private static final int[][] VERTEX_CLASSIII;
    private static final int[][] VERTEX_CLASSII;
    int face;
    CoordIJK coord;

    FaceIJK(int face, CoordIJK coord) {
        this.face = face;
        this.coord = coord;
    }

    public Overage adjustOverageClassII(int res, boolean pentLeading4, boolean substrate) {
        Overage overage = Overage.NO_OVERAGE;
        int maxDim = maxDimByCIIres[res];
        if (substrate) {
            maxDim *= 3;
        }
        if (substrate && this.coord.i + this.coord.j + this.coord.k == maxDim) {
            overage = Overage.FACE_EDGE;
        } else if (this.coord.i + this.coord.j + this.coord.k > maxDim) {
            FaceOrientIJK fijkOrient;
            overage = Overage.NEW_FACE;
            if (this.coord.k > 0) {
                if (this.coord.j > 0) {
                    fijkOrient = faceNeighbors[this.face][3];
                } else {
                    fijkOrient = faceNeighbors[this.face][2];
                    if (pentLeading4) {
                        this.coord.ijkSub(maxDim, 0, 0);
                        this.coord.ijkRotate60cw();
                        this.coord.ijkAdd(maxDim, 0, 0);
                    }
                }
            } else {
                fijkOrient = faceNeighbors[this.face][1];
            }
            this.face = fijkOrient.face;
            for (int i = 0; i < fijkOrient.ccwRot60; ++i) {
                this.coord.ijkRotate60ccw();
            }
            int unitScale = unitScaleByCIIres[res];
            if (substrate) {
                unitScale *= 3;
            }
            this.coord.ijkAdd(fijkOrient.translateI * unitScale, fijkOrient.translateJ * unitScale, fijkOrient.translateK * unitScale);
            this.coord.ijkNormalize();
            if (substrate && this.coord.i + this.coord.j + this.coord.k == maxDim) {
                overage = Overage.FACE_EDGE;
            }
        }
        return overage;
    }

    public LatLng faceIjkToGeo(int res) {
        return this.coord.ijkToGeo(this.face, res, false);
    }

    public CellBoundary faceIjkPentToCellBoundary(int res) {
        this.coord.downAp3();
        this.coord.downAp3r();
        int adjRes = FaceIJK.adjustRes(this.coord, res);
        if (H3Index.isResolutionClassIII(res)) {
            return this.faceIjkPentToCellBoundaryClassIII(adjRes);
        }
        return this.faceIjkPentToCellBoundaryClassII(adjRes);
    }

    private CellBoundary faceIjkPentToCellBoundaryClassII(int adjRes) {
        LatLng[] points = new LatLng[5];
        FaceIJK fijk = new FaceIJK(this.face, new CoordIJK(0, 0, 0));
        for (int vert = 0; vert < 5; ++vert) {
            fijk.coord.reset(VERTEX_CLASSII[vert][0] + this.coord.i, VERTEX_CLASSII[vert][1] + this.coord.j, VERTEX_CLASSII[vert][2] + this.coord.k);
            fijk.coord.ijkNormalize();
            fijk.face = this.face;
            fijk.adjustPentVertOverage(adjRes);
            points[vert] = fijk.coord.ijkToGeo(fijk.face, adjRes, true);
        }
        return new CellBoundary(points, 5);
    }

    private CellBoundary faceIjkPentToCellBoundaryClassIII(int adjRes) {
        LatLng[] points = new LatLng[10];
        int numPoints = 0;
        FaceIJK fijk = new FaceIJK(this.face, new CoordIJK(0, 0, 0));
        CoordIJK lastCoord = new CoordIJK(0, 0, 0);
        int lastFace = this.face;
        for (int vert = 0; vert < 6; ++vert) {
            int v = vert % 5;
            fijk.coord.reset(VERTEX_CLASSIII[v][0] + this.coord.i, VERTEX_CLASSIII[v][1] + this.coord.j, VERTEX_CLASSIII[v][2] + this.coord.k);
            fijk.coord.ijkNormalize();
            fijk.face = this.face;
            fijk.adjustPentVertOverage(adjRes);
            if (vert > 0) {
                Vec2d orig2d0 = lastCoord.ijkToHex2d();
                int currentToLastDir = adjacentFaceDir[fijk.face][lastFace];
                FaceOrientIJK fijkOrient = faceNeighbors[fijk.face][currentToLastDir];
                lastCoord.reset(fijk.coord.i, fijk.coord.j, fijk.coord.k);
                for (int i = 0; i < fijkOrient.ccwRot60; ++i) {
                    lastCoord.ijkRotate60ccw();
                }
                int unitScale = unitScaleByCIIres[adjRes] * 3;
                lastCoord.ijkAdd(fijkOrient.translateI * unitScale, fijkOrient.translateJ * unitScale, fijkOrient.translateK * unitScale);
                lastCoord.ijkNormalize();
                Vec2d orig2d1 = lastCoord.ijkToHex2d();
                Vec2d inter = this.findIntersectionPoint(orig2d0, orig2d1, adjRes, adjacentFaceDir[fijkOrient.face][fijk.face]);
                if (inter != null) {
                    points[numPoints++] = inter.hex2dToGeo(fijkOrient.face, adjRes, true);
                }
            }
            if (vert < 5) {
                points[numPoints++] = fijk.coord.ijkToGeo(fijk.face, adjRes, true);
            }
            lastFace = fijk.face;
            lastCoord.reset(fijk.coord.i, fijk.coord.j, fijk.coord.k);
        }
        return new CellBoundary(points, numPoints);
    }

    public CellBoundary faceIjkToCellBoundary(int res) {
        this.coord.downAp3();
        this.coord.downAp3r();
        int adjRes = FaceIJK.adjustRes(this.coord, res);
        if (H3Index.isResolutionClassIII(res)) {
            return this.faceIjkToCellBoundaryClassIII(adjRes);
        }
        return this.faceIjkToCellBoundaryClassII(adjRes);
    }

    private static int adjustRes(CoordIJK coord, int res) {
        if (H3Index.isResolutionClassIII(res)) {
            coord.downAp7r();
            ++res;
        }
        return res;
    }

    private CellBoundary faceIjkToCellBoundaryClassII(int adjRes) {
        LatLng[] points = new LatLng[6];
        FaceIJK fijk = new FaceIJK(this.face, new CoordIJK(0, 0, 0));
        for (int vert = 0; vert < 6; ++vert) {
            fijk.coord.reset(VERTEX_CLASSII[vert][0] + this.coord.i, VERTEX_CLASSII[vert][1] + this.coord.j, VERTEX_CLASSII[vert][2] + this.coord.k);
            fijk.coord.ijkNormalize();
            fijk.face = this.face;
            fijk.adjustOverageClassII(adjRes, false, true);
            points[vert] = fijk.coord.ijkToGeo(fijk.face, adjRes, true);
        }
        return new CellBoundary(points, 6);
    }

    private CellBoundary faceIjkToCellBoundaryClassIII(int adjRes) {
        LatLng[] points = new LatLng[10];
        int numPoints = 0;
        FaceIJK fijk = new FaceIJK(this.face, new CoordIJK(0, 0, 0));
        CoordIJK scratch = new CoordIJK(0, 0, 0);
        int lastFace = -1;
        Overage lastOverage = Overage.NO_OVERAGE;
        for (int vert = 0; vert < 7; ++vert) {
            int face2;
            Vec2d orig2d1;
            int lastV;
            Vec2d orig2d0;
            Vec2d inter;
            int v = vert % 6;
            fijk.coord.reset(VERTEX_CLASSIII[v][0] + this.coord.i, VERTEX_CLASSIII[v][1] + this.coord.j, VERTEX_CLASSIII[v][2] + this.coord.k);
            fijk.coord.ijkNormalize();
            fijk.face = this.face;
            Overage overage = fijk.adjustOverageClassII(adjRes, false, true);
            if (vert > 0 && fijk.face != lastFace && lastOverage != Overage.FACE_EDGE && (inter = this.findIntersectionPoint(orig2d0 = this.orig(scratch, VERTEX_CLASSIII[lastV = (v + 5) % 6]), orig2d1 = this.orig(scratch, VERTEX_CLASSIII[v]), adjRes, adjacentFaceDir[this.face][face2 = lastFace == this.face ? fijk.face : lastFace])) != null) {
                points[numPoints++] = inter.hex2dToGeo(this.face, adjRes, true);
            }
            if (vert < 6) {
                points[numPoints++] = fijk.coord.ijkToGeo(fijk.face, adjRes, true);
            }
            lastFace = fijk.face;
            lastOverage = overage;
        }
        return new CellBoundary(points, numPoints);
    }

    private Vec2d orig(CoordIJK scratch, int[] vertexLast) {
        scratch.reset(vertexLast[0] + this.coord.i, vertexLast[1] + this.coord.j, vertexLast[2] + this.coord.k);
        scratch.ijkNormalize();
        return scratch.ijkToHex2d();
    }

    private Vec2d findIntersectionPoint(Vec2d orig2d0, Vec2d orig2d1, int adjRes, int faceDir) {
        Vec2d edge0;
        Vec2d inter = Vec2d.v2dIntersect(orig2d0, orig2d1, edge0, switch (faceDir) {
            case 1 -> {
                edge0 = maxDimByCIIVec2d[adjRes][0];
                yield maxDimByCIIVec2d[adjRes][1];
            }
            case 3 -> {
                edge0 = maxDimByCIIVec2d[adjRes][1];
                yield maxDimByCIIVec2d[adjRes][2];
            }
            default -> {
                if (!$assertionsDisabled && faceDir != 2) {
                    throw new AssertionError();
                }
                edge0 = maxDimByCIIVec2d[adjRes][2];
                yield maxDimByCIIVec2d[adjRes][0];
            }
        });
        return orig2d0.numericallyIdentical(inter) || orig2d1.numericallyIdentical(inter) ? null : inter;
    }

    static long faceIjkToH3(int res, int face, CoordIJK coord) {
        long h = 0x1FFFFFFFFFFFL;
        h = H3Index.H3_set_mode(h, 1L);
        h = H3Index.H3_set_resolution(h, res);
        if (res == 0) {
            if (coord.i > 2 || coord.j > 2 || coord.k > 2) {
                throw new IllegalArgumentException(" out of range input");
            }
            return H3Index.H3_set_base_cell(h, BaseCells.getBaseCell(face, coord));
        }
        CoordIJK scratch = new CoordIJK(0, 0, 0);
        for (int r = res; r > 0; --r) {
            int lastI = coord.i;
            int lastJ = coord.j;
            int lastK = coord.k;
            if (H3Index.isResolutionClassIII(r)) {
                coord.upAp7();
                scratch.reset(coord.i, coord.j, coord.k);
                scratch.downAp7();
            } else {
                coord.upAp7r();
                scratch.reset(coord.i, coord.j, coord.k);
                scratch.downAp7r();
            }
            scratch.reset(lastI - scratch.i, lastJ - scratch.j, lastK - scratch.k);
            scratch.ijkNormalize();
            h = H3Index.H3_set_index_digit(h, r, scratch.unitIjkToDigit());
        }
        if (coord.i > 2 || coord.j > 2 || coord.k > 2) {
            throw new IllegalArgumentException(" out of range input");
        }
        int baseCell = BaseCells.getBaseCell(face, coord);
        h = H3Index.H3_set_base_cell(h, baseCell);
        int numRots = BaseCells.getBaseCellCCWrot60(face, coord);
        if (BaseCells.isBaseCellPentagon(baseCell)) {
            if (H3Index.h3LeadingNonZeroDigit(h) == CoordIJK.Direction.K_AXES_DIGIT.digit()) {
                h = BaseCells.baseCellIsCwOffset(baseCell, face) ? H3Index.h3Rotate60cw(h) : H3Index.h3Rotate60ccw(h);
            }
            for (i = 0; i < numRots; ++i) {
                h = H3Index.h3RotatePent60ccw(h);
            }
        } else {
            for (i = 0; i < numRots; ++i) {
                h = H3Index.h3Rotate60ccw(h);
            }
        }
        return h;
    }

    private void adjustPentVertOverage(int res) {
        Overage overage;
        while ((overage = this.adjustOverageClassII(res, false, true)) == Overage.NEW_FACE) {
        }
    }

    static {
        for (int i = 0; i < maxDimByCIIres.length; ++i) {
            FaceIJK.maxDimByCIIVec2d[i][0] = new Vec2d(3.0 * (double)maxDimByCIIres[i], 0.0);
            FaceIJK.maxDimByCIIVec2d[i][1] = new Vec2d(-1.5 * (double)maxDimByCIIres[i], 2.598076211353316 * (double)maxDimByCIIres[i]);
            FaceIJK.maxDimByCIIVec2d[i][2] = new Vec2d(-1.5 * (double)maxDimByCIIres[i], -2.598076211353316 * (double)maxDimByCIIres[i]);
        }
        unitScaleByCIIres = new int[]{1, -1, 7, -1, 49, -1, 343, -1, 2401, -1, 16807, -1, 117649, -1, 823543, -1, 5764801};
        adjacentFaceDir = new int[][]{{0, 2, -1, -1, 1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 0, 2, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 1, 0, 2, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, 1, 0, 2, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, -1, -1, 1, 0, -1, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, -1, -1, -1, -1, 0, -1, -1, -1, -1, 1, -1, -1, -1, 2, -1, -1, -1, -1, -1}, {-1, 3, -1, -1, -1, -1, 0, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, 3, -1, -1, -1, -1, 0, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, 3, -1, -1, -1, -1, 0, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 3, -1, -1, -1, -1, 0, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, 1, 2, -1, -1, -1, 0, -1, -1, -1, -1, 3, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 1, 2, -1, -1, -1, 0, -1, -1, -1, -1, 3, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, 1, 2, -1, -1, -1, 0, -1, -1, -1, -1, 3, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, 1, 2, -1, -1, -1, 0, -1, -1, -1, -1, 3, -1}, {-1, -1, -1, -1, -1, 2, -1, -1, -1, 1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 3}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, -1, 0, 1, -1, -1, 2}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, 2, 0, 1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, 2, 0, 1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, 2, 0, 1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, 1, -1, -1, 2, 0}};
        faceNeighbors = new FaceOrientIJK[][]{{new FaceOrientIJK(0, 0, 0, 0, 0), new FaceOrientIJK(4, 2, 0, 2, 1), new FaceOrientIJK(1, 2, 2, 0, 5), new FaceOrientIJK(5, 0, 2, 2, 3)}, {new FaceOrientIJK(1, 0, 0, 0, 0), new FaceOrientIJK(0, 2, 0, 2, 1), new FaceOrientIJK(2, 2, 2, 0, 5), new FaceOrientIJK(6, 0, 2, 2, 3)}, {new FaceOrientIJK(2, 0, 0, 0, 0), new FaceOrientIJK(1, 2, 0, 2, 1), new FaceOrientIJK(3, 2, 2, 0, 5), new FaceOrientIJK(7, 0, 2, 2, 3)}, {new FaceOrientIJK(3, 0, 0, 0, 0), new FaceOrientIJK(2, 2, 0, 2, 1), new FaceOrientIJK(4, 2, 2, 0, 5), new FaceOrientIJK(8, 0, 2, 2, 3)}, {new FaceOrientIJK(4, 0, 0, 0, 0), new FaceOrientIJK(3, 2, 0, 2, 1), new FaceOrientIJK(0, 2, 2, 0, 5), new FaceOrientIJK(9, 0, 2, 2, 3)}, {new FaceOrientIJK(5, 0, 0, 0, 0), new FaceOrientIJK(10, 2, 2, 0, 3), new FaceOrientIJK(14, 2, 0, 2, 3), new FaceOrientIJK(0, 0, 2, 2, 3)}, {new FaceOrientIJK(6, 0, 0, 0, 0), new FaceOrientIJK(11, 2, 2, 0, 3), new FaceOrientIJK(10, 2, 0, 2, 3), new FaceOrientIJK(1, 0, 2, 2, 3)}, {new FaceOrientIJK(7, 0, 0, 0, 0), new FaceOrientIJK(12, 2, 2, 0, 3), new FaceOrientIJK(11, 2, 0, 2, 3), new FaceOrientIJK(2, 0, 2, 2, 3)}, {new FaceOrientIJK(8, 0, 0, 0, 0), new FaceOrientIJK(13, 2, 2, 0, 3), new FaceOrientIJK(12, 2, 0, 2, 3), new FaceOrientIJK(3, 0, 2, 2, 3)}, {new FaceOrientIJK(9, 0, 0, 0, 0), new FaceOrientIJK(14, 2, 2, 0, 3), new FaceOrientIJK(13, 2, 0, 2, 3), new FaceOrientIJK(4, 0, 2, 2, 3)}, {new FaceOrientIJK(10, 0, 0, 0, 0), new FaceOrientIJK(5, 2, 2, 0, 3), new FaceOrientIJK(6, 2, 0, 2, 3), new FaceOrientIJK(15, 0, 2, 2, 3)}, {new FaceOrientIJK(11, 0, 0, 0, 0), new FaceOrientIJK(6, 2, 2, 0, 3), new FaceOrientIJK(7, 2, 0, 2, 3), new FaceOrientIJK(16, 0, 2, 2, 3)}, {new FaceOrientIJK(12, 0, 0, 0, 0), new FaceOrientIJK(7, 2, 2, 0, 3), new FaceOrientIJK(8, 2, 0, 2, 3), new FaceOrientIJK(17, 0, 2, 2, 3)}, {new FaceOrientIJK(13, 0, 0, 0, 0), new FaceOrientIJK(8, 2, 2, 0, 3), new FaceOrientIJK(9, 2, 0, 2, 3), new FaceOrientIJK(18, 0, 2, 2, 3)}, {new FaceOrientIJK(14, 0, 0, 0, 0), new FaceOrientIJK(9, 2, 2, 0, 3), new FaceOrientIJK(5, 2, 0, 2, 3), new FaceOrientIJK(19, 0, 2, 2, 3)}, {new FaceOrientIJK(15, 0, 0, 0, 0), new FaceOrientIJK(16, 2, 0, 2, 1), new FaceOrientIJK(19, 2, 2, 0, 5), new FaceOrientIJK(10, 0, 2, 2, 3)}, {new FaceOrientIJK(16, 0, 0, 0, 0), new FaceOrientIJK(17, 2, 0, 2, 1), new FaceOrientIJK(15, 2, 2, 0, 5), new FaceOrientIJK(11, 0, 2, 2, 3)}, {new FaceOrientIJK(17, 0, 0, 0, 0), new FaceOrientIJK(18, 2, 0, 2, 1), new FaceOrientIJK(16, 2, 2, 0, 5), new FaceOrientIJK(12, 0, 2, 2, 3)}, {new FaceOrientIJK(18, 0, 0, 0, 0), new FaceOrientIJK(19, 2, 0, 2, 1), new FaceOrientIJK(17, 2, 2, 0, 5), new FaceOrientIJK(13, 0, 2, 2, 3)}, {new FaceOrientIJK(19, 0, 0, 0, 0), new FaceOrientIJK(15, 2, 0, 2, 1), new FaceOrientIJK(18, 2, 2, 0, 5), new FaceOrientIJK(14, 0, 2, 2, 3)}};
        VERTEX_CLASSIII = new int[][]{{5, 4, 0}, {1, 5, 0}, {0, 5, 4}, {0, 1, 5}, {4, 0, 5}, {5, 0, 1}};
        VERTEX_CLASSII = new int[][]{{2, 1, 0}, {1, 2, 0}, {0, 2, 1}, {0, 1, 2}, {1, 0, 2}, {2, 0, 1}};
    }

    static enum Overage {
        NO_OVERAGE,
        FACE_EDGE,
        NEW_FACE;

    }

    private record FaceOrientIJK(int face, int translateI, int translateJ, int translateK, int ccwRot60) {
    }
}

