/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.type;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;

public class KeywordEsField
extends EsField {
    private final int precision;
    private final boolean normalized;

    public KeywordEsField(String name) {
        this(name, Collections.emptyMap(), true, Short.MAX_VALUE, false);
    }

    public KeywordEsField(String name, Map<String, EsField> properties, boolean hasDocValues, int precision, boolean normalized) {
        this(name, properties, hasDocValues, precision, normalized, false);
    }

    public KeywordEsField(String name, Map<String, EsField> properties, boolean hasDocValues, int precision, boolean normalized, boolean isAlias) {
        this(name, DataTypes.KEYWORD, properties, hasDocValues, precision, normalized, isAlias);
    }

    protected KeywordEsField(String name, DataType esDataType, Map<String, EsField> properties, boolean hasDocValues, int precision, boolean normalized, boolean isAlias) {
        super(name, esDataType, properties, hasDocValues, isAlias);
        this.precision = precision;
        this.normalized = normalized;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean getNormalized() {
        return this.normalized;
    }

    @Override
    public EsField.Exact getExactInfo() {
        return new EsField.Exact(!this.normalized, "Normalized keyword field cannot be used for exact match operations");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeywordEsField that = (KeywordEsField)o;
        return this.precision == that.precision && this.normalized == that.normalized;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision, this.normalized);
    }
}

