/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.rrf;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RRFRetrieverComponent
implements ToXContentObject {
    public static final ParseField RETRIEVER_FIELD = new ParseField("retriever", new String[0]);
    public static final ParseField WEIGHT_FIELD = new ParseField("weight", new String[0]);
    static final float DEFAULT_WEIGHT = 1.0f;
    final RetrieverBuilder retriever;
    final float weight;

    public RRFRetrieverComponent(RetrieverBuilder retrieverBuilder, Float weight) {
        this.retriever = Objects.requireNonNull(retrieverBuilder, "retrieverBuilder must not be null");
        float f = this.weight = weight == null ? 1.0f : weight.floatValue();
        if (this.weight < 0.0f) {
            throw new IllegalArgumentException("[weight] must be non-negative, found [" + this.weight + "]");
        }
    }

    public RetrieverBuilder retriever() {
        return this.retriever;
    }

    public float weight() {
        return this.weight;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RETRIEVER_FIELD.getPreferredName(), (ToXContent)this.retriever);
        builder.field(WEIGHT_FIELD.getPreferredName(), this.weight);
        builder.endObject();
        return builder;
    }

    public static RRFRetrieverComponent fromXContent(XContentParser parser, RetrieverParserContext context) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "expected object but found [{}]", new Object[]{parser.currentToken()});
        }
        XContentParser.Token token = parser.nextToken();
        if (token == XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "retriever component must contain a retriever", new Object[0]);
        }
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "expected field name but found [{}]", new Object[]{token});
        }
        String firstFieldName = parser.currentName();
        if (RETRIEVER_FIELD.match(firstFieldName, parser.getDeprecationHandler()) || WEIGHT_FIELD.match(firstFieldName, parser.getDeprecationHandler())) {
            RetrieverBuilder retriever = null;
            Float weight = null;
            do {
                String fieldName;
                if (RETRIEVER_FIELD.match(fieldName = parser.currentName(), parser.getDeprecationHandler())) {
                    if (retriever != null) {
                        throw new ParsingException(parser.getTokenLocation(), "only one retriever can be specified", new Object[0]);
                    }
                    parser.nextToken();
                    if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                        throw new ParsingException(parser.getTokenLocation(), "retriever must be an object", new Object[0]);
                    }
                    parser.nextToken();
                    String retrieverType = parser.currentName();
                    retriever = (RetrieverBuilder)parser.namedObject(RetrieverBuilder.class, retrieverType, (Object)context);
                    context.trackRetrieverUsage(retriever);
                    parser.nextToken();
                    continue;
                }
                if (WEIGHT_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                    if (weight != null) {
                        throw new ParsingException(parser.getTokenLocation(), "[weight] field can only be specified once", new Object[0]);
                    }
                    parser.nextToken();
                    weight = Float.valueOf(parser.floatValue());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "unknown field [{}], expected [{}] or [{}]", new Object[]{fieldName, RETRIEVER_FIELD.getPreferredName(), WEIGHT_FIELD.getPreferredName()});
            } while (parser.nextToken() == XContentParser.Token.FIELD_NAME);
            if (retriever == null) {
                throw new ParsingException(parser.getTokenLocation(), "retriever component must contain a retriever", new Object[0]);
            }
            return new RRFRetrieverComponent(retriever, weight);
        }
        RetrieverBuilder retriever = (RetrieverBuilder)parser.namedObject(RetrieverBuilder.class, firstFieldName, (Object)context);
        context.trackRetrieverUsage(retriever);
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "unknown field [{}] after retriever", new Object[]{parser.currentName()});
        }
        return new RRFRetrieverComponent(retriever, Float.valueOf(1.0f));
    }
}

