/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.pytorch.results;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.utils.MlParserUtils;

public class PyTorchInferenceResult
implements ToXContentObject {
    private static final ParseField INFERENCE = new ParseField("inference", new String[0]);
    public static final ConstructingObjectParser<PyTorchInferenceResult, Void> PARSER = new ConstructingObjectParser("pytorch_inference_result", a -> new PyTorchInferenceResult((double[][][])a[0]));
    private final double[][][] inference;

    public static PyTorchInferenceResult fromXContent(XContentParser parser) throws IOException {
        return (PyTorchInferenceResult)PARSER.parse(parser, null);
    }

    public PyTorchInferenceResult(@Nullable double[][][] inference) {
        this.inference = inference;
    }

    public double[][][] getInferenceResult() {
        return this.inference;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.inference != null) {
            builder.startArray(INFERENCE.getPreferredName());
            for (double[][] doubles : this.inference) {
                builder.startArray();
                for (int j = 0; j < this.inference[0].length; ++j) {
                    builder.value((Object)doubles[j]);
                }
                builder.endArray();
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.inference);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PyTorchInferenceResult that = (PyTorchInferenceResult)other;
        return Arrays.deepEquals((Object[])this.inference, (Object[])that.inference);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> MlParserUtils.parse3DArrayOfDoubles((String)INFERENCE.getPreferredName(), (XContentParser)p), INFERENCE, ObjectParser.ValueType.VALUE_ARRAY);
    }
}

