/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.assignment.planning;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.ml.inference.assignment.planning.AbstractPreserveAllocations;
import org.elasticsearch.xpack.ml.inference.assignment.planning.AssignmentPlan;

public class PreserveAllAllocations
extends AbstractPreserveAllocations {
    protected PreserveAllAllocations(List<AssignmentPlan.Node> nodes, List<AssignmentPlan.Deployment> deployments) {
        super(nodes, deployments);
    }

    @Override
    protected int calculateUsedCores(AssignmentPlan.Node n, AssignmentPlan.Deployment m) {
        return m.currentAllocationsByNodeId().get(n.id()) * m.threadsPerAllocation();
    }

    @Override
    protected Map<String, Integer> calculateAllocationsPerNodeToPreserve(AssignmentPlan.Deployment m) {
        return m.currentAllocationsByNodeId().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> 0));
    }

    @Override
    protected int calculatePreservedAllocations(AssignmentPlan.Deployment m) {
        return m.currentAllocationsByNodeId().values().stream().mapToInt(Integer::intValue).sum();
    }

    @Override
    protected int addPreservedAllocations(AssignmentPlan.Node n, AssignmentPlan.Deployment m) {
        return m.currentAllocationsByNodeId().containsKey(n.id()) ? m.currentAllocationsByNodeId().get(n.id()) : 0;
    }
}

