/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.GetInferenceModelAction;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.UpdateTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentClusterService;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;

public class TransportUpdateTrainedModelDeploymentAction
extends TransportMasterNodeAction<UpdateTrainedModelDeploymentAction.Request, CreateTrainedModelAssignmentAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateTrainedModelDeploymentAction.class);
    private final TrainedModelAssignmentClusterService trainedModelAssignmentClusterService;
    private final InferenceAuditor auditor;
    private final ProjectResolver projectResolver;
    private final Client client;

    @Inject
    public TransportUpdateTrainedModelDeploymentAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, TrainedModelAssignmentClusterService trainedModelAssignmentClusterService, InferenceAuditor auditor, ProjectResolver projectResolver, Client client) {
        super("cluster:admin/xpack/ml/trained_models/deployment/update", transportService, clusterService, threadPool, actionFilters, UpdateTrainedModelDeploymentAction.Request::new, CreateTrainedModelAssignmentAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.trainedModelAssignmentClusterService = Objects.requireNonNull(trainedModelAssignmentClusterService);
        this.auditor = Objects.requireNonNull(auditor);
        this.projectResolver = Objects.requireNonNull(projectResolver);
        this.client = new OriginSettingClient(Objects.requireNonNull(client), "ml");
    }

    protected void masterOperation(Task task, UpdateTrainedModelDeploymentAction.Request request, ClusterState state, ActionListener<CreateTrainedModelAssignmentAction.Response> listener) throws Exception {
        logger.debug("[{}] received request to update number of allocations to [{}]", (Object)request.getDeploymentId(), (Object)request.getNumberOfAllocations());
        this.checkIfUsedByDefaultInferenceEndpoint(task, request, (ActionListener<Void>)listener.delegateFailureAndWrap((l, unused) -> this.updateDeployment(request, (ActionListener<CreateTrainedModelAssignmentAction.Response>)l)));
    }

    private void checkIfUsedByDefaultInferenceEndpoint(Task task, UpdateTrainedModelDeploymentAction.Request request, ActionListener<Void> listener) {
        if (request.isInternal()) {
            listener.onResponse(null);
            return;
        }
        String deploymentId = request.getDeploymentId();
        ParentTaskAssigningClient parentClient = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), task);
        GetInferenceModelAction.Request getAllEndpoints = new GetInferenceModelAction.Request("*", TaskType.ANY);
        if (request.ackTimeout() != null) {
            getAllEndpoints.ackTimeout(request.ackTimeout());
        }
        parentClient.execute((ActionType)GetInferenceModelAction.INSTANCE, (ActionRequest)getAllEndpoints, listener.delegateFailureAndWrap((l, response) -> response.getEndpoints().stream().filter(model -> model.getService().equals("elasticsearch") || model.getService().equals("elser")).map(ModelConfigurations::getInferenceEntityId).filter(deploymentId::equals).findAny().ifPresentOrElse(endpointId -> l.onFailure((Exception)new ElasticsearchStatusException("Cannot update deployment [{}] as it was created by inference endpoint [{}]. This model deployment must be updated through the inference API.", RestStatus.CONFLICT, new Object[]{deploymentId, endpointId})), () -> l.onResponse(null))));
    }

    private void updateDeployment(UpdateTrainedModelDeploymentAction.Request request, ActionListener<CreateTrainedModelAssignmentAction.Response> listener) {
        this.trainedModelAssignmentClusterService.updateDeployment(request.getDeploymentId(), request.getNumberOfAllocations(), request.getAdaptiveAllocationsSettings(), request.isInternal(), (ActionListener<TrainedModelAssignment>)listener.delegateFailureAndWrap((l, updatedAssignment) -> {
            this.auditor.info(request.getDeploymentId(), Messages.getMessage((String)"Updated number_of_allocations to [{0}]", (Object[])new Object[]{request.getNumberOfAllocations()}));
            listener.onResponse((Object)new CreateTrainedModelAssignmentAction.Response(updatedAssignment));
        }));
    }

    protected ClusterBlockException checkBlock(UpdateTrainedModelDeploymentAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE);
    }
}

