/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.LinkedProjectConfig;
import org.elasticsearch.transport.LinkedProjectConfigService;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xpack.ccr.action.repositories.DeleteInternalCcrRepositoryAction;
import org.elasticsearch.xpack.ccr.action.repositories.DeleteInternalCcrRepositoryRequest;
import org.elasticsearch.xpack.ccr.action.repositories.PutInternalCcrRepositoryAction;
import org.elasticsearch.xpack.ccr.action.repositories.PutInternalCcrRepositoryRequest;

class CcrRepositoryManager
extends AbstractLifecycleComponent {
    private final Client client;
    private final RemoteSettingsUpdateListener updateListener;
    private final LinkedProjectConfigService linkedProjectConfigService;

    CcrRepositoryManager(Settings settings, LinkedProjectConfigService linkedProjectConfigService, Client client) {
        this.client = client;
        this.updateListener = new RemoteSettingsUpdateListener(settings);
        linkedProjectConfigService.register((LinkedProjectConfigService.LinkedProjectConfigListener)this.updateListener);
        this.linkedProjectConfigService = linkedProjectConfigService;
    }

    protected void doStart() {
        this.updateListener.init();
    }

    protected void doStop() {
    }

    protected void doClose() {
    }

    private void putRepository(String repositoryName) {
        PutInternalCcrRepositoryRequest request = new PutInternalCcrRepositoryRequest(repositoryName, "_ccr_");
        PlainActionFuture f = new PlainActionFuture();
        this.client.execute((ActionType)PutInternalCcrRepositoryAction.INSTANCE, (ActionRequest)request, (ActionListener)f);
        assert (f.isDone()) : "Should be completed as it is executed synchronously";
    }

    private void deleteRepository(String repositoryName) {
        DeleteInternalCcrRepositoryRequest request = new DeleteInternalCcrRepositoryRequest(repositoryName);
        PlainActionFuture f = new PlainActionFuture();
        this.client.execute((ActionType)DeleteInternalCcrRepositoryAction.INSTANCE, (ActionRequest)request, (ActionListener)f);
        assert (f.isDone()) : "Should be completed as it is executed synchronously";
    }

    private class RemoteSettingsUpdateListener
    extends RemoteClusterAware {
        private RemoteSettingsUpdateListener(Settings settings) {
            super(settings);
        }

        void init() {
            for (LinkedProjectConfig config : CcrRepositoryManager.this.linkedProjectConfigService.getInitialLinkedProjectConfigs()) {
                CcrRepositoryManager.this.putRepository("_ccr_" + config.linkedProjectAlias());
            }
        }

        public void updateLinkedProject(LinkedProjectConfig config) {
            String repositoryName = "_ccr_" + config.linkedProjectAlias();
            if (config.isConnectionEnabled()) {
                CcrRepositoryManager.this.putRepository(repositoryName);
            } else {
                CcrRepositoryManager.this.deleteRepository(repositoryName);
            }
        }
    }
}

