/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class TopNOperatorStatus
implements Operator.Status {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "topn", TopNOperatorStatus::new);
    private static final TransportVersion ESQL_TOPN_TIMINGS = TransportVersion.fromName((String)"esql_topn_timings");
    private final long receiveNanos;
    private final long emitNanos;
    private final int occupiedRows;
    private final long ramBytesUsed;
    private final int pagesReceived;
    private final int pagesEmitted;
    private final long rowsReceived;
    private final long rowsEmitted;

    public TopNOperatorStatus(long receiveNanos, long emitNanos, int occupiedRows, long ramBytesUsed, int pagesReceived, int pagesEmitted, long rowsReceived, long rowsEmitted) {
        this.receiveNanos = receiveNanos;
        this.emitNanos = emitNanos;
        this.occupiedRows = occupiedRows;
        this.ramBytesUsed = ramBytesUsed;
        this.pagesReceived = pagesReceived;
        this.pagesEmitted = pagesEmitted;
        this.rowsReceived = rowsReceived;
        this.rowsEmitted = rowsEmitted;
    }

    TopNOperatorStatus(StreamInput in) throws IOException {
        if (in.getTransportVersion().supports(ESQL_TOPN_TIMINGS)) {
            this.receiveNanos = in.readVLong();
            this.emitNanos = in.readVLong();
        } else {
            this.receiveNanos = 0L;
            this.emitNanos = 0L;
        }
        this.occupiedRows = in.readVInt();
        this.ramBytesUsed = in.readVLong();
        this.pagesReceived = in.readVInt();
        this.pagesEmitted = in.readVInt();
        this.rowsReceived = in.readVLong();
        this.rowsEmitted = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(ESQL_TOPN_TIMINGS)) {
            out.writeVLong(this.receiveNanos);
            out.writeVLong(this.emitNanos);
        }
        out.writeVInt(this.occupiedRows);
        out.writeVLong(this.ramBytesUsed);
        out.writeVInt(this.pagesReceived);
        out.writeVInt(this.pagesEmitted);
        out.writeVLong(this.rowsReceived);
        out.writeVLong(this.rowsEmitted);
    }

    public String getWriteableName() {
        return TopNOperatorStatus.ENTRY.name;
    }

    public long receiveNanos() {
        return this.receiveNanos;
    }

    public long emitNanos() {
        return this.emitNanos;
    }

    public int occupiedRows() {
        return this.occupiedRows;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    public int pagesReceived() {
        return this.pagesReceived;
    }

    public int pagesEmitted() {
        return this.pagesEmitted;
    }

    public long rowsReceived() {
        return this.rowsReceived;
    }

    public long rowsEmitted() {
        return this.rowsEmitted;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("receive_nanos", this.receiveNanos);
        if (builder.humanReadable()) {
            builder.field("receive_time", TimeValue.timeValueNanos((long)this.receiveNanos).toString());
        }
        builder.field("emit_nanos", this.emitNanos);
        if (builder.humanReadable()) {
            builder.field("emit_time", TimeValue.timeValueNanos((long)this.emitNanos).toString());
        }
        builder.field("occupied_rows", this.occupiedRows);
        builder.field("ram_bytes_used", this.ramBytesUsed);
        builder.field("ram_used", (ToXContent)ByteSizeValue.ofBytes((long)this.ramBytesUsed));
        builder.field("pages_received", this.pagesReceived);
        builder.field("pages_emitted", this.pagesEmitted);
        builder.field("rows_received", this.rowsReceived);
        builder.field("rows_emitted", this.rowsEmitted);
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopNOperatorStatus that = (TopNOperatorStatus)o;
        return this.receiveNanos == that.receiveNanos && this.emitNanos == that.emitNanos && this.occupiedRows == that.occupiedRows && this.ramBytesUsed == that.ramBytesUsed && this.pagesReceived == that.pagesReceived && this.pagesEmitted == that.pagesEmitted && this.rowsReceived == that.rowsReceived && this.rowsEmitted == that.rowsEmitted;
    }

    public int hashCode() {
        return Objects.hash(this.receiveNanos, this.emitNanos, this.occupiedRows, this.ramBytesUsed, this.pagesReceived, this.pagesEmitted, this.rowsReceived, this.rowsEmitted);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_11_X;
    }
}

