/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import java.util.List;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BooleanBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.BytesRef2BlockHash;
import org.elasticsearch.compute.aggregation.blockhash.BytesRef3BlockHash;
import org.elasticsearch.compute.aggregation.blockhash.BytesRefBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.BytesRefLongBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.CategorizeBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.CategorizePackedValuesBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.DoubleBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.IntBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.LongBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.LongLongBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.LongTopNBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.NullBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.PackedValuesBlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.index.analysis.AnalysisRegistry;

public abstract class BlockHash
implements Releasable,
SeenGroupIds {
    protected final BlockFactory blockFactory;

    BlockHash(BlockFactory blockFactory) {
        this.blockFactory = blockFactory;
    }

    public abstract void add(Page var1, GroupingAggregatorFunction.AddInput var2);

    public abstract ReleasableIterator<IntBlock> lookup(Page var1, ByteSizeValue var2);

    public abstract Block[] getKeys();

    public abstract IntVector nonEmpty();

    @Override
    public abstract BitArray seenGroupIds(BigArrays var1);

    public static BlockHash build(List<GroupSpec> groups, BlockFactory blockFactory, int emitBatchSize, boolean allowBrokenOptimizations) {
        if (groups.size() == 1) {
            GroupSpec group = groups.get(0);
            if (group.topNDef() != null && group.elementType() == ElementType.LONG) {
                TopNDef topNDef = group.topNDef();
                return new LongTopNBlockHash(group.channel(), topNDef.asc(), topNDef.nullsFirst(), topNDef.limit(), blockFactory);
            }
            return BlockHash.newForElementType(group.channel(), group.elementType(), blockFactory);
        }
        if (groups.stream().allMatch(g -> g.elementType == ElementType.BYTES_REF)) {
            switch (groups.size()) {
                case 2: {
                    return new BytesRef2BlockHash(blockFactory, groups.get((int)0).channel, groups.get((int)1).channel, emitBatchSize);
                }
                case 3: {
                    return new BytesRef3BlockHash(blockFactory, groups.get((int)0).channel, groups.get((int)1).channel, groups.get((int)2).channel, emitBatchSize);
                }
            }
        }
        if (allowBrokenOptimizations && groups.size() == 2) {
            GroupSpec g1 = groups.get(0);
            GroupSpec g2 = groups.get(1);
            if (g1.elementType() == ElementType.LONG && g2.elementType() == ElementType.LONG) {
                return new LongLongBlockHash(blockFactory, g1.channel(), g2.channel(), emitBatchSize);
            }
            if (g1.elementType() == ElementType.BYTES_REF && g2.elementType() == ElementType.LONG) {
                return new BytesRefLongBlockHash(blockFactory, g1.channel(), g2.channel(), false, emitBatchSize);
            }
            if (g1.elementType() == ElementType.LONG && g2.elementType() == ElementType.BYTES_REF) {
                return new BytesRefLongBlockHash(blockFactory, g2.channel(), g1.channel(), true, emitBatchSize);
            }
        }
        return new PackedValuesBlockHash(groups, blockFactory, emitBatchSize);
    }

    public static BlockHash buildPackedValuesBlockHash(List<GroupSpec> groups, BlockFactory blockFactory, int emitBatchSize) {
        return new PackedValuesBlockHash(groups, blockFactory, emitBatchSize);
    }

    public static BlockHash buildCategorizeBlockHash(List<GroupSpec> groups, AggregatorMode aggregatorMode, BlockFactory blockFactory, AnalysisRegistry analysisRegistry, int emitBatchSize) {
        if (groups.size() == 1) {
            return new CategorizeBlockHash(blockFactory, groups.get((int)0).channel, aggregatorMode, groups.get((int)0).categorizeDef, analysisRegistry);
        }
        assert (groups.get(0).isCategorize());
        assert (groups.subList(1, groups.size()).stream().noneMatch(GroupSpec::isCategorize));
        return new CategorizePackedValuesBlockHash(groups, blockFactory, aggregatorMode, analysisRegistry, emitBatchSize);
    }

    private static BlockHash newForElementType(int channel, ElementType type, BlockFactory blockFactory) {
        return switch (type) {
            case ElementType.NULL -> new NullBlockHash(channel, blockFactory);
            case ElementType.BOOLEAN -> new BooleanBlockHash(channel, blockFactory);
            case ElementType.INT -> new IntBlockHash(channel, blockFactory);
            case ElementType.LONG -> new LongBlockHash(channel, blockFactory);
            case ElementType.DOUBLE -> new DoubleBlockHash(channel, blockFactory);
            case ElementType.BYTES_REF -> new BytesRefBlockHash(channel, blockFactory);
            default -> throw new IllegalArgumentException("unsupported grouping element type [" + String.valueOf((Object)type) + "]");
        };
    }

    public static long hashOrdToGroup(long ord) {
        if (ord < 0L) {
            return -1L - ord;
        }
        return ord;
    }

    public static long hashOrdToGroupNullReserved(long ord) {
        return BlockHash.hashOrdToGroup(ord) + 1L;
    }

    public record GroupSpec(int channel, ElementType elementType, @Nullable CategorizeDef categorizeDef, @Nullable TopNDef topNDef) {
        public GroupSpec(int channel, ElementType elementType) {
            this(channel, elementType, null, null);
        }

        public GroupSpec(int channel, ElementType elementType, CategorizeDef categorizeDef) {
            this(channel, elementType, categorizeDef, null);
        }

        public boolean isCategorize() {
            return this.categorizeDef != null;
        }
    }

    public record TopNDef(int order, boolean asc, boolean nullsFirst, int limit) {
    }

    public record CategorizeDef(String analyzer, OutputFormat outputFormat, int similarityThreshold) {

        public static enum OutputFormat {
            REGEX,
            TOKENS;

        }
    }
}

