/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.ValuesBytesRefAggregator;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class ValuesBytesRefAggregators {
    ValuesBytesRefAggregators() {
    }

    static GroupingAggregatorFunction.AddInput wrapAddInput(final GroupingAggregatorFunction.AddInput delegate, final ValuesBytesRefAggregator.GroupingState state, BytesRefBlock values) {
        OrdinalBytesRefBlock valuesOrdinal = values.asOrdinals();
        if (valuesOrdinal == null) {
            return delegate;
        }
        final IntVector hashIds = ValuesBytesRefAggregators.hashDict(state, valuesOrdinal.getDictionaryVector());
        final IntBlock ordinalIds = valuesOrdinal.getOrdinalsBlock();
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                for (int groupPosition = 0; groupPosition < groupIds.getPositionCount(); ++groupPosition) {
                    if (groupIds.isNull(groupPosition)) continue;
                    int groupStart = groupIds.getFirstValueIndex(groupPosition);
                    int groupEnd = groupStart + groupIds.getValueCount(groupPosition);
                    for (int g = groupStart; g < groupEnd; ++g) {
                        int groupId = groupIds.getInt(g);
                        if (ordinalIds.isNull(groupPosition + positionOffset)) continue;
                        int valuesStart = ordinalIds.getFirstValueIndex(groupPosition + positionOffset);
                        int valuesEnd = valuesStart + ordinalIds.getValueCount(groupPosition + positionOffset);
                        for (int v = valuesStart; v < valuesEnd; ++v) {
                            state.addValueOrdinal(groupId, hashIds.getInt(ordinalIds.getInt(v)));
                        }
                    }
                }
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                for (int groupPosition = 0; groupPosition < groupIds.getPositionCount(); ++groupPosition) {
                    if (groupIds.isNull(groupPosition)) continue;
                    int groupStart = groupIds.getFirstValueIndex(groupPosition);
                    int groupEnd = groupStart + groupIds.getValueCount(groupPosition);
                    for (int g = groupStart; g < groupEnd; ++g) {
                        int groupId = groupIds.getInt(g);
                        if (ordinalIds.isNull(groupPosition + positionOffset)) continue;
                        int valuesStart = ordinalIds.getFirstValueIndex(groupPosition + positionOffset);
                        int valuesEnd = valuesStart + ordinalIds.getValueCount(groupPosition + positionOffset);
                        for (int v = valuesStart; v < valuesEnd; ++v) {
                            state.addValueOrdinal(groupId, hashIds.getInt(ordinalIds.getInt(v)));
                        }
                    }
                }
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                ValuesBytesRefAggregators.addOrdinalInputBlock(state, positionOffset, groupIds, ordinalIds, hashIds);
            }

            public void close() {
                Releasables.close((Releasable[])new Releasable[]{hashIds, delegate});
            }
        };
    }

    static GroupingAggregatorFunction.AddInput wrapAddInput(final GroupingAggregatorFunction.AddInput delegate, final ValuesBytesRefAggregator.GroupingState state, BytesRefVector values) {
        OrdinalBytesRefVector valuesOrdinal = values.asOrdinals();
        if (valuesOrdinal == null) {
            return delegate;
        }
        final IntVector hashIds = ValuesBytesRefAggregators.hashDict(state, valuesOrdinal.getDictionaryVector());
        final IntVector ordinalIds = valuesOrdinal.getOrdinalsVector();
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                for (int groupPosition = 0; groupPosition < groupIds.getPositionCount(); ++groupPosition) {
                    if (groupIds.isNull(groupPosition)) continue;
                    int groupStart = groupIds.getFirstValueIndex(groupPosition);
                    int groupEnd = groupStart + groupIds.getValueCount(groupPosition);
                    for (int g = groupStart; g < groupEnd; ++g) {
                        int groupId = groupIds.getInt(g);
                        state.addValueOrdinal(groupId, hashIds.getInt(ordinalIds.getInt(groupPosition + positionOffset)));
                    }
                }
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                for (int groupPosition = 0; groupPosition < groupIds.getPositionCount(); ++groupPosition) {
                    if (groupIds.isNull(groupPosition)) continue;
                    int groupStart = groupIds.getFirstValueIndex(groupPosition);
                    int groupEnd = groupStart + groupIds.getValueCount(groupPosition);
                    for (int g = groupStart; g < groupEnd; ++g) {
                        int groupId = groupIds.getInt(g);
                        state.addValueOrdinal(groupId, hashIds.getInt(ordinalIds.getInt(groupPosition + positionOffset)));
                    }
                }
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                ValuesBytesRefAggregators.addOrdinalInputVector(state, positionOffset, groupIds, ordinalIds, hashIds);
            }

            public void close() {
                Releasables.close((Releasable[])new Releasable[]{hashIds, delegate});
            }
        };
    }

    static IntVector hashDict(ValuesBytesRefAggregator.GroupingState state, BytesRefVector dict) {
        BytesRef scratch = new BytesRef();
        try (IntVector.FixedBuilder hashIdsBuilder = dict.blockFactory().newIntVectorFixedBuilder(dict.getPositionCount());){
            for (int p = 0; p < dict.getPositionCount(); ++p) {
                long hashId = BlockHash.hashOrdToGroup(state.bytes.add(dict.getBytesRef(p, scratch)));
                hashIdsBuilder.appendInt(Math.toIntExact(hashId));
            }
            IntVector intVector = hashIdsBuilder.build();
            return intVector;
        }
    }

    static void addOrdinalInputBlock(ValuesBytesRefAggregator.GroupingState state, int positionOffset, IntVector groupIds, IntBlock ordinalIds, IntVector hashIds) {
        for (int p = 0; p < groupIds.getPositionCount(); ++p) {
            int groupId = groupIds.getInt(p);
            int valuePosition = p + positionOffset;
            int start = ordinalIds.getFirstValueIndex(valuePosition);
            int end = start + ordinalIds.getValueCount(valuePosition);
            for (int i = start; i < end; ++i) {
                int ord = ordinalIds.getInt(i);
                state.addValueOrdinal(groupId, hashIds.getInt(ord));
            }
        }
    }

    static void addOrdinalInputVector(ValuesBytesRefAggregator.GroupingState state, int positionOffset, IntVector groupIds, IntVector ordinalIds, IntVector hashIds) {
        if (groupIds.isConstant() && hashIds.isConstant()) {
            state.addValueOrdinal(groupIds.getInt(0), hashIds.getInt(0));
            return;
        }
        int lastGroup = groupIds.getInt(0);
        int lastOrd = ordinalIds.getInt(positionOffset);
        state.addValueOrdinal(lastGroup, hashIds.getInt(lastOrd));
        for (int p = 1; p < groupIds.getPositionCount(); ++p) {
            int nextGroup = groupIds.getInt(p);
            int nextOrd = ordinalIds.getInt(p + positionOffset);
            if (nextGroup == lastGroup && nextOrd == lastOrd) continue;
            lastGroup = nextGroup;
            lastOrd = nextOrd;
            state.addValueOrdinal(lastGroup, hashIds.getInt(lastOrd));
        }
    }

    static void combineIntermediateInputValues(ValuesBytesRefAggregator.GroupingState state, int positionOffset, IntVector groupIds, BytesRefBlock values) {
        BytesRefVector dict = null;
        IntBlock ordinals = null;
        OrdinalBytesRefBlock asOrdinals = values.asOrdinals();
        if (asOrdinals != null) {
            dict = asOrdinals.getDictionaryVector();
            ordinals = asOrdinals.getOrdinalsBlock();
        }
        if (dict != null && dict.getPositionCount() < groupIds.getPositionCount()) {
            try (IntVector hashIds = ValuesBytesRefAggregators.hashDict(state, dict);){
                IntVector ordinalsVector = ordinals.asVector();
                if (ordinalsVector != null) {
                    ValuesBytesRefAggregators.addOrdinalInputVector(state, positionOffset, groupIds, ordinalsVector, hashIds);
                }
                ValuesBytesRefAggregators.addOrdinalInputBlock(state, positionOffset, groupIds, ordinals, hashIds);
            }
        } else {
            BytesRef scratch = new BytesRef();
            for (int p = 0; p < groupIds.getPositionCount(); ++p) {
                int groupId = groupIds.getInt(p);
                int valuePosition = p + positionOffset;
                int start = values.getFirstValueIndex(valuePosition);
                int end = start + values.getValueCount(valuePosition);
                for (int i = start; i < end; ++i) {
                    state.addValue(groupId, values.getBytesRef(i, scratch));
                }
            }
        }
    }

    static void combineIntermediateInputValues(ValuesBytesRefAggregator.GroupingState state, int positionOffset, IntBlock groupIds, BytesRefBlock values) {
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groupIds.getPositionCount(); ++groupPosition) {
            if (groupIds.isNull(groupPosition)) continue;
            int groupStart = groupIds.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groupIds.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                if (values.isNull(groupPosition + positionOffset)) continue;
                int groupId = groupIds.getInt(g);
                int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
                int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
                for (int v = valuesStart; v < valuesEnd; ++v) {
                    BytesRef bytes = values.getBytesRef(v, scratch);
                    state.addValue(groupId, bytes);
                }
            }
        }
    }
}

