/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.ValuesBooleanAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class ValuesBooleanGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("values", ElementType.BOOLEAN));
    private final ValuesBooleanAggregator.GroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public ValuesBooleanGroupingAggregatorFunction(List<Integer> channels, ValuesBooleanAggregator.GroupingState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static ValuesBooleanGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new ValuesBooleanGroupingAggregatorFunction(channels, ValuesBooleanAggregator.initGrouping(driverContext.bigArrays()), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final BooleanBlock vBlock = (BooleanBlock)page.getBlock(this.channels.get(0));
        final BooleanVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, vBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    ValuesBooleanGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    ValuesBooleanGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    ValuesBooleanGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                ValuesBooleanGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                ValuesBooleanGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                ValuesBooleanGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, BooleanBlock vBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || vBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int vStart = vBlock.getFirstValueIndex(valuesPosition);
                int vEnd = vStart + vBlock.getValueCount(valuesPosition);
                for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                    boolean vValue = vBlock.getBoolean(vOffset);
                    ValuesBooleanAggregator.combine(this.state, groupId, vValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, BooleanVector vVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                boolean vValue = vVector.getBoolean(valuesPosition);
                ValuesBooleanAggregator.combine(this.state, groupId, vValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object valuesUncast = page.getBlock(this.channels.get(0));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        BooleanBlock values = (BooleanBlock)valuesUncast;
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                ValuesBooleanAggregator.combineIntermediate(this.state, groupId, values, valuesPosition);
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, BooleanBlock vBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || vBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int vStart = vBlock.getFirstValueIndex(valuesPosition);
                int vEnd = vStart + vBlock.getValueCount(valuesPosition);
                for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                    boolean vValue = vBlock.getBoolean(vOffset);
                    ValuesBooleanAggregator.combine(this.state, groupId, vValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, BooleanVector vVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                boolean vValue = vVector.getBoolean(valuesPosition);
                ValuesBooleanAggregator.combine(this.state, groupId, vValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object valuesUncast = page.getBlock(this.channels.get(0));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        BooleanBlock values = (BooleanBlock)valuesUncast;
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                ValuesBooleanAggregator.combineIntermediate(this.state, groupId, values, valuesPosition);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, BooleanBlock vBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (vBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int vStart = vBlock.getFirstValueIndex(valuesPosition);
            int vEnd = vStart + vBlock.getValueCount(valuesPosition);
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                boolean vValue = vBlock.getBoolean(vOffset);
                ValuesBooleanAggregator.combine(this.state, groupId, vValue);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, BooleanVector vVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            int groupId = groups.getInt(groupPosition);
            boolean vValue = vVector.getBoolean(valuesPosition);
            ValuesBooleanAggregator.combine(this.state, groupId, vValue);
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object valuesUncast = page.getBlock(this.channels.get(0));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        BooleanBlock values = (BooleanBlock)valuesUncast;
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            ValuesBooleanAggregator.combineIntermediate(this.state, groupId, values, valuesPosition);
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, BooleanBlock vBlock) {
        if (vBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = ValuesBooleanAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

