/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.FloatState;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.MaxFloatAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class MaxFloatAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("max", ElementType.FLOAT), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final FloatState state;
    private final List<Integer> channels;

    public MaxFloatAggregatorFunction(DriverContext driverContext, List<Integer> channels, FloatState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static MaxFloatAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new MaxFloatAggregatorFunction(driverContext, channels, new FloatState(MaxFloatAggregator.init()));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        FloatBlock vBlock = (FloatBlock)page.getBlock(this.channels.get(0));
        FloatVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, mask);
            return;
        }
        this.addRawVector(vVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        FloatBlock vBlock = (FloatBlock)page.getBlock(this.channels.get(0));
        FloatVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock);
            return;
        }
        this.addRawVector(vVector);
    }

    private void addRawVector(FloatVector vVector) {
        this.state.seen(true);
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            float vValue = vVector.getFloat(valuesPosition);
            this.state.floatValue(MaxFloatAggregator.combine(this.state.floatValue(), vValue));
        }
    }

    private void addRawVector(FloatVector vVector, BooleanVector mask) {
        this.state.seen(true);
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            float vValue = vVector.getFloat(valuesPosition);
            this.state.floatValue(MaxFloatAggregator.combine(this.state.floatValue(), vValue));
        }
    }

    private void addRawBlock(FloatBlock vBlock) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            if (vBlock.isNull(p)) continue;
            this.state.seen(true);
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vBlock.getValueCount(p);
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                float vValue = vBlock.getFloat(vOffset);
                this.state.floatValue(MaxFloatAggregator.combine(this.state.floatValue(), vValue));
            }
        }
    }

    private void addRawBlock(FloatBlock vBlock, BooleanVector mask) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || vBlock.isNull(p)) continue;
            this.state.seen(true);
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vBlock.getValueCount(p);
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                float vValue = vBlock.getFloat(vOffset);
                this.state.floatValue(MaxFloatAggregator.combine(this.state.floatValue(), vValue));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + MaxFloatAggregatorFunction.intermediateStateDesc().size());
        Object maxUncast = page.getBlock(this.channels.get(0));
        if (maxUncast.areAllValuesNull()) {
            return;
        }
        FloatVector max = ((FloatBlock)maxUncast).asVector();
        assert (max.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        if (seen.getBoolean(0)) {
            this.state.floatValue(MaxFloatAggregator.combine(this.state.floatValue(), max.getFloat(0)));
            this.state.seen(true);
        }
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        if (!this.state.seen()) {
            blocks[offset] = driverContext.blockFactory().newConstantNullBlock(1);
            return;
        }
        blocks[offset] = driverContext.blockFactory().newConstantFloatBlockWith(this.state.floatValue(), 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

