/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.operator.DriverContext;

final class LongDoubleState
implements AggregatorState {
    private long v1;
    private double v2;
    private boolean seen;

    LongDoubleState(long v1, double v2) {
        this.v1 = v1;
        this.v2 = v2;
    }

    long v1() {
        return this.v1;
    }

    void v1(long v1) {
        this.v1 = v1;
    }

    double v2() {
        return this.v2;
    }

    void v2(double v2) {
        this.v2 = v2;
    }

    boolean seen() {
        return this.seen;
    }

    void seen(boolean seen) {
        this.seen = seen;
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        assert (blocks.length >= offset + 3);
        blocks[offset + 0] = driverContext.blockFactory().newConstantLongBlockWith(this.v1, 1);
        blocks[offset + 1] = driverContext.blockFactory().newConstantDoubleBlockWith(this.v2, 1);
        blocks[offset + 2] = driverContext.blockFactory().newConstantBooleanBlockWith(this.seen, 1);
    }

    public void close() {
    }
}

