/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filters;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.transform.TransformFeatureSetUsage;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.TransformInfoTransportAction;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransformUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private static final Logger logger = LogManager.getLogger(TransformUsageTransportAction.class);
    private static final String FEATURE_COUNTS = "feature_counts";
    private static final String[] FEATURES = (String[])Stream.concat(Stream.of(TransformConfig.Function.values()).map(TransformConfig.Function::getParseField), Stream.of(TransformField.RETENTION_POLICY, TransformField.SYNC)).map(ParseField::getPreferredName).toArray(String[]::new);
    private final Client client;

    @Inject
    public TransformUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super(XPackUsageFeatureAction.TRANSFORM.name(), transportService, clusterService, threadPool, actionFilters);
        this.client = client;
    }

    protected void localClusterStateOperation(Task task, XPackUsageRequest request, ClusterState clusterState, ActionListener<XPackUsageFeatureResponse> listener) {
        Collection<PersistentTasksCustomMetadata.PersistentTask<?>> transformTasks = TransformTask.findAllTransformTasks(clusterState);
        int taskCount = transformTasks.size();
        HashMap transformsCountByState = new HashMap();
        for (PersistentTasksCustomMetadata.PersistentTask<?> transformTask : transformTasks) {
            TransformState transformState = (TransformState)transformTask.getState();
            Optional.ofNullable(transformState).map(TransformState::getTaskState).map(TransformTaskState::value).ifPresent(value -> transformsCountByState.merge(value, 1L, Long::sum));
        }
        SetOnce transformsCountByFeature = new SetOnce();
        ActionListener totalStatsListener = listener.delegateFailureAndWrap((l, statSummations) -> {
            TransformFeatureSetUsage usage = new TransformFeatureSetUsage(transformsCountByState, (Map)transformsCountByFeature.get(), statSummations);
            l.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)usage));
        });
        ActionListener totalTransformCountListener = ActionListener.wrap(transformCountSuccess -> {
            long totalTransforms;
            if (transformCountSuccess.getShardFailures().length > 0) {
                logger.error("total transform count search returned shard failures: {}", (Object)Arrays.toString(transformCountSuccess.getShardFailures()));
            }
            if ((totalTransforms = transformCountSuccess.getHits().getTotalHits().value()) == 0L) {
                TransformFeatureSetUsage usage = new TransformFeatureSetUsage(transformsCountByState, Collections.emptyMap(), new TransformIndexerStats());
                listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)usage));
                return;
            }
            transformsCountByState.merge(TransformTaskState.STOPPED.value(), totalTransforms - (long)taskCount, Long::sum);
            transformsCountByFeature.set(TransformUsageTransportAction.getFeatureCounts(transformCountSuccess.getAggregations()));
            TransformInfoTransportAction.getStatisticSummations(this.client, (ActionListener<TransformIndexerStats>)totalStatsListener);
        }, transformCountFailure -> {
            if (transformCountFailure instanceof ResourceNotFoundException) {
                TransformInfoTransportAction.getStatisticSummations(this.client, (ActionListener<TransformIndexerStats>)totalStatsListener);
            } else {
                listener.onFailure(transformCountFailure);
            }
        });
        SearchRequest totalTransformCountSearchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).setTrackTotalHits(true).setSize(0).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_config")))).addAggregation((AggregationBuilder)AggregationBuilders.filters((String)FEATURE_COUNTS, (FiltersAggregator.KeyedFilter[])((FiltersAggregator.KeyedFilter[])Arrays.stream(FEATURES).map(f -> new FiltersAggregator.KeyedFilter(f, (QueryBuilder)QueryBuilders.existsQuery((String)f))).toArray(FiltersAggregator.KeyedFilter[]::new)))).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"transform", (Object)totalTransformCountSearchRequest, (ActionListener)totalTransformCountListener, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    private static Map<String, Long> getFeatureCounts(InternalAggregations aggs) {
        Filters filters = (Filters)aggs.get(FEATURE_COUNTS);
        return filters.getBuckets().stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, MultiBucketsAggregation.Bucket::getDocCount));
    }
}

