/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.search.uhighlight;

import java.io.IOException;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.util.BytesRef;

public class LimitedOffsetsEnum
extends OffsetsEnum {
    private final OffsetsEnum delegate;
    private final int maxOffset;

    public LimitedOffsetsEnum(OffsetsEnum delegate, int maxOffset) {
        this.delegate = delegate;
        this.maxOffset = maxOffset;
    }

    public boolean nextPosition() throws IOException {
        boolean next = this.delegate.nextPosition();
        if (!next) {
            return next;
        }
        if (this.delegate.startOffset() > this.maxOffset) {
            return false;
        }
        return next;
    }

    public int freq() throws IOException {
        return this.delegate.freq();
    }

    public BytesRef getTerm() throws IOException {
        return this.delegate.getTerm();
    }

    public int startOffset() throws IOException {
        return this.delegate.startOffset();
    }

    public int endOffset() throws IOException {
        return this.delegate.endOffset();
    }
}

