/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.rest;

import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.datastreams.lifecycle.ExplainDataStreamLifecycleAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;

@ServerlessScope(value=Scope.PUBLIC)
public class RestExplainDataStreamLifecycleAction
extends BaseRestHandler {
    public String getName() {
        return "data_stream_lifecycle_explain_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_lifecycle/explain"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String[] indices = Strings.splitStringByCommaToArray((String)restRequest.param("index"));
        ExplainDataStreamLifecycleAction.Request explainRequest = new ExplainDataStreamLifecycleAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)restRequest), indices);
        explainRequest.includeDefaults(restRequest.paramAsBoolean("include_defaults", false));
        explainRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)restRequest, (IndicesOptions)IndicesOptions.strictExpandOpen()));
        return channel -> client.execute(ExplainDataStreamLifecycleAction.INSTANCE, (ActionRequest)explainRequest, (ActionListener)new RestRefCountedChunkedToXContentListener(channel));
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    public Set<String> supportedCapabilities() {
        return Set.of("data_stream_lifecycle_effective_retention");
    }
}

