/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.BackoffPolicy;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.SnapshotMetrics;
import org.elasticsearch.repositories.blobstore.MeteredBlobStoreRepository;
import org.elasticsearch.repositories.gcs.GcsRepositoryStatsCollector;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageBlobStore;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

class GoogleCloudStorageRepository
extends MeteredBlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(GoogleCloudStorageRepository.class);
    static final ByteSizeValue MIN_CHUNK_SIZE = ByteSizeValue.ONE;
    static final ByteSizeValue MAX_CHUNK_SIZE = ByteSizeValue.of((long)5L, (ByteSizeUnit)ByteSizeUnit.TB);
    static final String TYPE = "gcs";
    static final Setting<String> BUCKET = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<String> BASE_PATH = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<ByteSizeValue> CHUNK_SIZE = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)MAX_CHUNK_SIZE, (ByteSizeValue)MIN_CHUNK_SIZE, (ByteSizeValue)MAX_CHUNK_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<String> CLIENT_NAME = Setting.simpleString((String)"client", (String)"default", (Setting.Property[])new Setting.Property[0]);
    static final Setting<TimeValue> RETRY_THROTTLED_CAS_DELAY_INCREMENT = Setting.timeSetting((String)"throttled_cas_retry.delay_increment", (TimeValue)TimeValue.timeValueMillis((long)100L), (TimeValue)TimeValue.ZERO, (Setting.Property[])new Setting.Property[0]);
    static final Setting<Integer> RETRY_THROTTLED_CAS_MAX_NUMBER_OF_RETRIES = Setting.intSetting((String)"throttled_cas_retry.maximum_number_of_retries", (int)2, (int)0, (Setting.Property[])new Setting.Property[0]);
    static final Setting<TimeValue> RETRY_THROTTLED_CAS_MAXIMUM_DELAY = Setting.timeSetting((String)"throttled_cas_retry.maximum_delay", (TimeValue)TimeValue.timeValueSeconds((long)5L), (TimeValue)TimeValue.ZERO, (Setting.Property[])new Setting.Property[0]);
    private final GoogleCloudStorageService storageService;
    private final ByteSizeValue chunkSize;
    private final String bucket;
    private final String clientName;
    private final TimeValue retryThrottledCasDelayIncrement;
    private final int retryThrottledCasMaxNumberOfRetries;
    private final TimeValue retryThrottledCasMaxDelay;
    private final GcsRepositoryStatsCollector statsCollector;

    GoogleCloudStorageRepository(@Nullable ProjectId projectId, RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, GoogleCloudStorageService storageService, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, GcsRepositoryStatsCollector statsCollector, SnapshotMetrics snapshotMetrics) {
        super(projectId, metadata, namedXContentRegistry, clusterService, bigArrays, recoverySettings, GoogleCloudStorageRepository.buildBasePath(metadata), GoogleCloudStorageRepository.buildLocation(metadata), snapshotMetrics);
        this.storageService = storageService;
        this.chunkSize = GoogleCloudStorageRepository.getSetting(CHUNK_SIZE, metadata);
        this.bucket = GoogleCloudStorageRepository.getSetting(BUCKET, metadata);
        this.clientName = (String)CLIENT_NAME.get(metadata.settings());
        this.retryThrottledCasDelayIncrement = (TimeValue)RETRY_THROTTLED_CAS_DELAY_INCREMENT.get(metadata.settings());
        this.retryThrottledCasMaxNumberOfRetries = (Integer)RETRY_THROTTLED_CAS_MAX_NUMBER_OF_RETRIES.get(metadata.settings());
        this.retryThrottledCasMaxDelay = (TimeValue)RETRY_THROTTLED_CAS_MAXIMUM_DELAY.get(metadata.settings());
        this.statsCollector = statsCollector;
        logger.debug("using bucket [{}], base_path [{}], chunk_size [{}], compress [{}]", (Object)this.bucket, (Object)this.basePath(), (Object)this.chunkSize, (Object)this.isCompress());
    }

    private static BlobPath buildBasePath(RepositoryMetadata metadata) {
        String basePath = (String)BASE_PATH.get(metadata.settings());
        if (Strings.hasLength((String)basePath)) {
            BlobPath path = BlobPath.EMPTY;
            for (String elem : basePath.split("/")) {
                path = path.add(elem);
            }
            return path;
        }
        return BlobPath.EMPTY;
    }

    private static Map<String, String> buildLocation(RepositoryMetadata metadata) {
        return Map.of("base_path", (String)BASE_PATH.get(metadata.settings()), "bucket", GoogleCloudStorageRepository.getSetting(BUCKET, metadata));
    }

    protected GoogleCloudStorageBlobStore createBlobStore() {
        return new GoogleCloudStorageBlobStore(this.getProjectId(), this.bucket, this.clientName, this.metadata.name(), this.storageService, this.bigArrays, this.bufferSize, BackoffPolicy.linearBackoff((TimeValue)this.retryThrottledCasDelayIncrement, (int)this.retryThrottledCasMaxNumberOfRetries, (TimeValue)this.retryThrottledCasMaxDelay), this.statsCollector);
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    GcsRepositoryStatsCollector statsCollector() {
        return this.statsCollector;
    }

    static <T> T getSetting(Setting<T> setting, RepositoryMetadata metadata) {
        String string;
        Object value = setting.get(metadata.settings());
        if (value == null) {
            throw new RepositoryException(metadata.name(), "Setting [" + setting.getKey() + "] is not defined for repository", new Object[0]);
        }
        if (value instanceof String && !Strings.hasText((String)(string = (String)value))) {
            throw new RepositoryException(metadata.name(), "Setting [" + setting.getKey() + "] is empty for repository", new Object[0]);
        }
        return (T)value;
    }
}

