/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.azure.core.http.ProxyOptions;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RetryPolicyType;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.settings.ProjectSecrets;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.repositories.azure.AzureBlobServiceClient;
import org.elasticsearch.repositories.azure.AzureClientProvider;
import org.elasticsearch.repositories.azure.AzureStorageSettings;
import org.elasticsearch.repositories.azure.LocationMode;

public class AzureStorageService {
    private static final Logger logger = LogManager.getLogger(AzureStorageService.class);
    public static final ByteSizeValue MIN_CHUNK_SIZE = ByteSizeValue.ofBytes((long)1L);
    public static final ByteSizeValue MAX_BLOCK_SIZE = ByteSizeValue.of((long)100L, (ByteSizeUnit)ByteSizeUnit.MB);
    public static final long MAX_BLOCK_NUMBER = 50000L;
    private static final ByteSizeValue DEFAULT_BLOCK_SIZE = ByteSizeValue.ofBytes((long)Math.max(ByteSizeUnit.MB.toBytes(5L), Math.min(MAX_BLOCK_SIZE.getBytes(), JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 20L)));
    public static final long MAX_BLOB_SIZE = 50000L * DEFAULT_BLOCK_SIZE.getBytes();
    public static final ByteSizeValue MAX_CHUNK_SIZE = ByteSizeValue.ofBytes((long)MAX_BLOB_SIZE);
    private static final long DEFAULT_UPLOAD_BLOCK_SIZE = DEFAULT_BLOCK_SIZE.getBytes();
    private final int multipartUploadMaxConcurrency;
    private final AzureClientProvider azureClientProvider;
    private final ClientLogger clientLogger = new ClientLogger(AzureStorageService.class);
    private final AzureStorageClientsManager clientsManager;
    private final boolean stateless;

    public AzureStorageService(Settings settings, AzureClientProvider azureClientProvider, ClusterService clusterService, ProjectResolver projectResolver) {
        this.clientsManager = new AzureStorageClientsManager(settings, projectResolver.supportsMultipleProjects());
        this.azureClientProvider = azureClientProvider;
        this.stateless = DiscoveryNode.isStateless((Settings)settings);
        this.multipartUploadMaxConcurrency = azureClientProvider.getMultipartUploadMaxConcurrency();
        if (projectResolver.supportsMultipleProjects()) {
            clusterService.addHighPriorityApplier((ClusterStateApplier)this.clientsManager);
        }
    }

    public AzureBlobServiceClient client(@Nullable ProjectId projectId, String clientName, LocationMode locationMode, OperationPurpose purpose) {
        return this.client(projectId, clientName, locationMode, purpose, null);
    }

    public AzureBlobServiceClient client(@Nullable ProjectId projectId, String clientName, LocationMode locationMode, OperationPurpose purpose, AzureClientProvider.RequestMetricsHandler requestMetricsHandler) {
        return this.clientsManager.client(projectId, clientName, locationMode, purpose, requestMetricsHandler);
    }

    private AzureBlobServiceClient buildClient(LocationMode locationMode, OperationPurpose purpose, AzureClientProvider.RequestMetricsHandler requestMetricsHandler, AzureStorageSettings azureStorageSettings) {
        RequestRetryOptions retryOptions = this.getRetryOptions(locationMode, azureStorageSettings);
        ProxyOptions proxyOptions = AzureStorageService.getProxyOptions(azureStorageSettings);
        return this.azureClientProvider.createClient(azureStorageSettings, locationMode, retryOptions, proxyOptions, requestMetricsHandler, purpose);
    }

    private static ProxyOptions getProxyOptions(AzureStorageSettings settings) {
        Proxy proxy = settings.getProxy();
        if (proxy == null) {
            return null;
        }
        return switch (proxy.type()) {
            case Proxy.Type.HTTP -> new ProxyOptions(ProxyOptions.Type.HTTP, (InetSocketAddress)proxy.address());
            case Proxy.Type.SOCKS -> new ProxyOptions(ProxyOptions.Type.SOCKS5, (InetSocketAddress)proxy.address());
            default -> null;
        };
    }

    long getUploadBlockSize() {
        return DEFAULT_UPLOAD_BLOCK_SIZE;
    }

    int getMaxReadRetries(@Nullable ProjectId projectId, String clientName) {
        AzureStorageSettings azureStorageSettings = this.clientsManager.getClientSettings(projectId, clientName);
        return azureStorageSettings.getMaxRetries();
    }

    boolean isStateless() {
        return this.stateless;
    }

    RequestRetryOptions getRetryOptions(LocationMode locationMode, AzureStorageSettings azureStorageSettings) {
        AzureStorageSettings.StorageEndpoint endpoint = azureStorageSettings.getStorageEndpoint();
        String primaryUri = endpoint.primaryURI();
        String secondaryUri = endpoint.secondaryURI();
        if (locationMode == LocationMode.PRIMARY_THEN_SECONDARY && secondaryUri == null) {
            throw new IllegalArgumentException("Unable to use " + String.valueOf((Object)locationMode) + " location mode without a secondary location URI");
        }
        String secondaryHost = switch (locationMode) {
            default -> throw new MatchException(null, null);
            case LocationMode.PRIMARY_ONLY, LocationMode.SECONDARY_ONLY -> null;
            case LocationMode.PRIMARY_THEN_SECONDARY -> secondaryUri;
            case LocationMode.SECONDARY_THEN_PRIMARY -> primaryUri;
        };
        TimeValue configuredTimeout = azureStorageSettings.getTimeout();
        int timeout = configuredTimeout.duration() == -1L ? Integer.MAX_VALUE : Math.max(1, Math.toIntExact(configuredTimeout.getSeconds()));
        return new RequestRetryOptions(RetryPolicyType.EXPONENTIAL, Integer.valueOf(azureStorageSettings.getMaxRetries()), Integer.valueOf(timeout), null, null, secondaryHost);
    }

    public void refreshClusterClientSettings(Map<String, AzureStorageSettings> clientsSettings) {
        this.clientsManager.refreshClusterClientSettings(clientsSettings);
    }

    public Set<String> getExtraUsageFeatures(@Nullable ProjectId projectId, String clientName) {
        try {
            return this.clientsManager.getClientSettings(projectId, clientName).credentialsUsageFeatures();
        }
        catch (Exception e) {
            return Set.of();
        }
    }

    public int getMultipartUploadMaxConcurrency() {
        return this.multipartUploadMaxConcurrency;
    }

    Map<String, AzureStorageSettings> getStorageSettings() {
        return this.clientsManager.clusterStorageSettings;
    }

    AzureStorageClientsManager getClientsManager() {
        return this.clientsManager;
    }

    class AzureStorageClientsManager
    implements ClusterStateApplier {
        private static final String AZURE_SETTING_PREFIX = "azure.";
        private final Settings nodeAzureSettings;
        private volatile Map<String, AzureStorageSettings> clusterStorageSettings;
        private final Map<ProjectId, Map<String, AzureStorageSettings>> perProjectStorageSettings;

        AzureStorageClientsManager(Settings nodeSettings, boolean supportsMultipleProjects) {
            Map<String, AzureStorageSettings> clientsSettings = AzureStorageSettings.load(nodeSettings);
            this.refreshClusterClientSettings(clientsSettings);
            this.nodeAzureSettings = Settings.builder().put(nodeSettings.getByPrefix(AZURE_SETTING_PREFIX), false).normalizePrefix(AZURE_SETTING_PREFIX).build();
            this.perProjectStorageSettings = supportsMultipleProjects ? ConcurrentCollections.newConcurrentMap() : null;
        }

        public void applyClusterState(ClusterChangedEvent event) {
            assert (this.perProjectStorageSettings != null);
            Map currentProjects = event.state().metadata().projects();
            for (ProjectMetadata project : currentProjects.values()) {
                if (ProjectId.DEFAULT.equals((Object)project.id())) continue;
                ProjectSecrets projectSecrets = (ProjectSecrets)project.custom("project_state_secrets");
                if (projectSecrets == null || projectSecrets.getSettingNames().stream().noneMatch(key -> key.startsWith(AZURE_SETTING_PREFIX))) {
                    this.perProjectStorageSettings.remove(project.id());
                    continue;
                }
                Settings currentSettings = Settings.builder().put(this.nodeAzureSettings).setSecureSettings(projectSecrets.getSettings()).build();
                Map<String, AzureStorageSettings> allClientSettings = AzureStorageSettings.load(currentSettings);
                Map<String, AzureStorageSettings> clientSettingsWithCredentials = allClientSettings.entrySet().stream().filter(entry -> ((AzureStorageSettings)entry.getValue()).hasCredentials()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
                if (!this.newOrUpdated(project.id(), clientSettingsWithCredentials)) continue;
                if (allClientSettings.size() != clientSettingsWithCredentials.size()) {
                    logger.warn("Project [{}] has [{}] azure client settings, but [{}] is usable due to missing credentials for clients {}", (Object)project.id(), (Object)allClientSettings.size(), (Object)clientSettingsWithCredentials.size(), (Object)Sets.difference(allClientSettings.keySet(), clientSettingsWithCredentials.keySet()));
                }
                this.perProjectStorageSettings.put(project.id(), clientSettingsWithCredentials);
            }
            for (ProjectId projectId : this.perProjectStorageSettings.keySet()) {
                if (currentProjects.containsKey(projectId)) continue;
                assert (!ProjectId.DEFAULT.equals((Object)projectId));
                this.perProjectStorageSettings.remove(projectId);
            }
        }

        public AzureBlobServiceClient client(@Nullable ProjectId projectId, String clientName, LocationMode locationMode, OperationPurpose purpose, AzureClientProvider.RequestMetricsHandler requestMetricsHandler) {
            AzureStorageSettings azureStorageSettings = this.getClientSettings(projectId, clientName);
            return AzureStorageService.this.buildClient(locationMode, purpose, requestMetricsHandler, azureStorageSettings);
        }

        public AzureStorageSettings getClientSettings(@Nullable ProjectId projectId, String clientName) {
            Map<String, AzureStorageSettings> allClientSettings = this.getAllClientSettings(projectId);
            AzureStorageSettings azureStorageSettings = allClientSettings.get(clientName);
            if (azureStorageSettings == null) {
                throw new SettingsException("Unable to find client with name [" + clientName + "]" + (String)(AzureStorageClientsManager.isDefaultProjectIdOrNull(projectId) ? "" : " for project [" + String.valueOf(projectId) + "]"));
            }
            return azureStorageSettings;
        }

        Map<String, AzureStorageSettings> getAllClientSettings(@Nullable ProjectId projectId) {
            if (projectId == null || ProjectId.DEFAULT.equals((Object)projectId)) {
                return this.clusterStorageSettings;
            }
            Map<String, AzureStorageSettings> projectClientSettings = this.perProjectStorageSettings.get(projectId);
            if (projectClientSettings == null) {
                throw new SettingsException("Unable to find any client for project [" + String.valueOf(projectId) + "]");
            }
            return projectClientSettings;
        }

        Map<ProjectId, Map<String, AzureStorageSettings>> getPerProjectStorageSettings() {
            return this.perProjectStorageSettings == null ? null : Map.copyOf(this.perProjectStorageSettings);
        }

        private void refreshClusterClientSettings(Map<String, AzureStorageSettings> clientsSettings) {
            this.clusterStorageSettings = Map.copyOf(clientsSettings);
        }

        private boolean newOrUpdated(ProjectId projectId, Map<String, AzureStorageSettings> currentClientSettings) {
            Map<String, AzureStorageSettings> old = this.perProjectStorageSettings.get(projectId);
            if (old == null) {
                return true;
            }
            return !currentClientSettings.equals(old);
        }

        private static boolean isDefaultProjectIdOrNull(@Nullable ProjectId projectId) {
            return projectId == null || ProjectId.DEFAULT.equals((Object)projectId);
        }
    }
}

