/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiFunction;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistance;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.planner.PlannerSettings;

public class PushTopNToSource
extends PhysicalOptimizerRules.ParameterizedOptimizerRule<TopNExec, LocalPhysicalOptimizerContext> {
    private static final Pushable NO_OP = new NoOpPushable();

    @Override
    protected PhysicalPlan rule(TopNExec topNExec, LocalPhysicalOptimizerContext ctx) {
        Pushable pushable = PushTopNToSource.evaluatePushable(ctx.plannerSettings(), ctx.foldCtx(), topNExec, LucenePushdownPredicates.from(ctx.searchStats(), ctx.flags()));
        return pushable.rewrite(topNExec);
    }

    private static Pushable evaluatePushable(PlannerSettings plannerSettings, FoldContext ctx, TopNExec topNExec, LucenePushdownPredicates lucenePushdownPredicates) {
        EsQueryExec queryExec;
        EvalExec evalExec;
        PhysicalPlan physicalPlan;
        EsQueryExec queryExec2;
        PhysicalPlan child = topNExec.child();
        if (child instanceof EsQueryExec && (queryExec2 = (EsQueryExec)child).canPushSorts() && PushTopNToSource.canPushDownOrders(topNExec.order(), lucenePushdownPredicates) && PushTopNToSource.canPushLimit(topNExec, plannerSettings)) {
            return new PushableQueryExec(queryExec2);
        }
        if (child instanceof EvalExec && (physicalPlan = (evalExec = (EvalExec)child).child()) instanceof EsQueryExec && (queryExec = (EsQueryExec)physicalPlan).canPushSorts() && PushTopNToSource.canPushLimit(topNExec, plannerSettings)) {
            List<Order> orders = topNExec.order();
            List<Alias> fields = evalExec.fields();
            LinkedHashMap distances = new LinkedHashMap();
            AttributeMap.Builder aliasReplacedByBuilder = AttributeMap.builder();
            fields.forEach(alias -> {
                StDistance distance;
                Expression patt0$temp = alias.child();
                if (patt0$temp instanceof StDistance && (distance = (StDistance)patt0$temp).crsType() == BinarySpatialFunction.SpatialCrsType.GEO) {
                    distances.put(alias.id(), distance);
                } else {
                    Expression patt1$temp = alias.child();
                    if (patt1$temp instanceof Attribute) {
                        Attribute attr = (Attribute)patt1$temp;
                        aliasReplacedByBuilder.put(alias.toAttribute(), (Object)attr.toAttribute());
                    }
                }
            });
            AttributeMap aliasReplacedBy = aliasReplacedByBuilder.build();
            ArrayList<EsQueryExec.Sort> pushableSorts = new ArrayList<EsQueryExec.Sort>();
            for (Order order : orders) {
                FieldAttribute fieldAttribute;
                if (lucenePushdownPredicates.isPushableFieldAttribute(order.child())) {
                    pushableSorts.add(new EsQueryExec.FieldSort(((FieldAttribute)order.child()).exactAttribute(), order.direction(), order.nullsPosition()));
                    continue;
                }
                if (LucenePushdownPredicates.isPushableMetadataAttribute(order.child())) {
                    pushableSorts.add(new EsQueryExec.ScoreSort(order.direction()));
                    continue;
                }
                Expression expression = order.child();
                if (!(expression instanceof ReferenceAttribute)) break;
                ReferenceAttribute referenceAttribute = (ReferenceAttribute)expression;
                Attribute resolvedAttribute = (Attribute)aliasReplacedBy.resolve((Object)referenceAttribute, (Object)referenceAttribute);
                if (distances.containsKey(resolvedAttribute.id())) {
                    StDistance distance = (StDistance)distances.get(resolvedAttribute.id());
                    StDistance d = (StDistance)distance.transformDown(ReferenceAttribute.class, r -> (Expression)aliasReplacedBy.resolve(r, r));
                    PushableGeoDistance pushableGeoDistance = PushableGeoDistance.from(ctx, d, order);
                    if (pushableGeoDistance == null) break;
                    pushableSorts.add(pushableGeoDistance.sort());
                    continue;
                }
                Object object = aliasReplacedBy.resolve((Object)referenceAttribute, (Object)referenceAttribute);
                if (!(object instanceof FieldAttribute) || !lucenePushdownPredicates.isPushableFieldAttribute((Expression)(fieldAttribute = (FieldAttribute)object))) break;
                pushableSorts.add(new EsQueryExec.FieldSort(fieldAttribute.exactAttribute(), order.direction(), order.nullsPosition()));
            }
            if (!pushableSorts.isEmpty()) {
                return new PushableCompoundExec(evalExec, queryExec, pushableSorts);
            }
        }
        return NO_OP;
    }

    private static boolean canPushDownOrders(List<Order> orders, LucenePushdownPredicates lucenePushdownPredicates) {
        BiFunction<Expression, LucenePushdownPredicates, Boolean> isSortableAttribute = (exp, lpp) -> lpp.isPushableFieldAttribute((Expression)exp) || MetadataAttribute.isScoreAttribute((Expression)exp);
        return orders.stream().allMatch(o -> (Boolean)isSortableAttribute.apply(o.child(), lucenePushdownPredicates));
    }

    private static boolean canPushLimit(TopNExec topn, PlannerSettings plannerSettings) {
        return Foldables.limitValue(topn.limit(), topn.sourceText()) <= plannerSettings.luceneTopNLimit();
    }

    private static List<EsQueryExec.Sort> buildFieldSorts(List<Order> orders) {
        ArrayList<EsQueryExec.Sort> sorts = new ArrayList<EsQueryExec.Sort>(orders.size());
        for (Order o : orders) {
            Expression expression = o.child();
            if (expression instanceof FieldAttribute) {
                FieldAttribute fa = (FieldAttribute)expression;
                sorts.add(new EsQueryExec.FieldSort(fa.exactAttribute(), o.direction(), o.nullsPosition()));
                continue;
            }
            if (MetadataAttribute.isScoreAttribute((Expression)o.child())) {
                sorts.add(new EsQueryExec.ScoreSort(o.direction()));
                continue;
            }
            assert (false) : "unexpected ordering on expression type " + String.valueOf(o.child().getClass());
        }
        return sorts;
    }

    static interface Pushable {
        public PhysicalPlan rewrite(TopNExec var1);
    }

    record PushableQueryExec(EsQueryExec queryExec) implements Pushable
    {
        @Override
        public PhysicalPlan rewrite(TopNExec topNExec) {
            List<EsQueryExec.Sort> sorts = PushTopNToSource.buildFieldSorts(topNExec.order());
            Expression limit = topNExec.limit();
            return this.queryExec.withSorts(sorts).withLimit(limit);
        }
    }

    record PushableGeoDistance(FieldAttribute fieldAttribute, Order order, Point point) {
        private EsQueryExec.Sort sort() {
            return new EsQueryExec.GeoDistanceSort(this.fieldAttribute.exactAttribute(), this.order.direction(), this.point.getLat(), this.point.getLon());
        }

        private static PushableGeoDistance from(FoldContext ctx, StDistance distance, Order order) {
            Expression expression = distance.left();
            if (expression instanceof Attribute) {
                Attribute attr = (Attribute)expression;
                if (distance.right().foldable()) {
                    return PushableGeoDistance.from(ctx, attr, distance.right(), order);
                }
            }
            if ((expression = distance.right()) instanceof Attribute) {
                Attribute attr = (Attribute)expression;
                if (distance.left().foldable()) {
                    return PushableGeoDistance.from(ctx, attr, distance.left(), order);
                }
            }
            return null;
        }

        private static PushableGeoDistance from(FoldContext ctx, Attribute attr, Expression foldable, Order order) {
            if (attr instanceof FieldAttribute) {
                FieldAttribute fieldAttribute = (FieldAttribute)attr;
                Geometry geometry = SpatialRelatesUtils.makeGeometryFromLiteral(ctx, foldable);
                if (geometry instanceof Point) {
                    Point point = (Point)geometry;
                    return new PushableGeoDistance(fieldAttribute, order, point);
                }
            }
            return null;
        }
    }

    record PushableCompoundExec(EvalExec evalExec, EsQueryExec queryExec, List<EsQueryExec.Sort> pushableSorts) implements Pushable
    {
        @Override
        public PhysicalPlan rewrite(TopNExec topNExec) {
            return this.evalExec.replaceChild(this.queryExec.withSorts(this.pushableSorts).withLimit(topNExec.limit()));
        }
    }

    record NoOpPushable() implements Pushable
    {
        @Override
        public PhysicalPlan rewrite(TopNExec topNExec) {
            return topNExec;
        }
    }
}

