/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.util.Locale;
import java.util.concurrent.Flow;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.UnifiedChatCompletionException;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventProcessor;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceResponseHandler;
import org.elasticsearch.xpack.inference.services.elastic.response.ElasticInferenceServiceErrorResponseEntity;
import org.elasticsearch.xpack.inference.services.openai.OpenAiUnifiedStreamingProcessor;

public class ElasticInferenceServiceUnifiedChatCompletionResponseHandler
extends ElasticInferenceServiceResponseHandler {
    public ElasticInferenceServiceUnifiedChatCompletionResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, true);
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        ServerSentEventProcessor serverSentEventProcessor = new ServerSentEventProcessor(new ServerSentEventParser());
        OpenAiUnifiedStreamingProcessor openAiProcessor = new OpenAiUnifiedStreamingProcessor((m, e) -> ElasticInferenceServiceUnifiedChatCompletionResponseHandler.buildMidStreamError(request, m, e));
        flow.subscribe(serverSentEventProcessor);
        serverSentEventProcessor.subscribe(openAiProcessor);
        return new StreamingUnifiedChatCompletionResults((Flow.Publisher)openAiProcessor);
    }

    @Override
    protected Exception buildError(String message, Request request, HttpResult result, ErrorResponse errorResponse) {
        assert (request.isStreaming()) : "Only streaming requests support this format";
        int responseStatusCode = result.response().getStatusLine().getStatusCode();
        if (request.isStreaming()) {
            RestStatus restStatus = ElasticInferenceServiceUnifiedChatCompletionResponseHandler.toRestStatus(responseStatusCode);
            return new UnifiedChatCompletionException(restStatus, ElasticInferenceServiceUnifiedChatCompletionResponseHandler.constructErrorMessage(message, request, errorResponse, responseStatusCode), "error", restStatus.name().toLowerCase(Locale.ROOT));
        }
        return super.buildError(message, request, result, errorResponse);
    }

    private static Exception buildMidStreamError(Request request, String message, Exception e) {
        ErrorResponse errorResponse = ElasticInferenceServiceErrorResponseEntity.fromString(message);
        if (errorResponse.errorStructureFound()) {
            return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, Strings.format((String)"%s for request from inference entity id [%s]. Error message: [%s]", (Object[])new Object[]{"Received an error response", request.getInferenceEntityId(), errorResponse.getErrorMessage()}), "error", "stream_error");
        }
        if (e != null) {
            return UnifiedChatCompletionException.fromThrowable((Throwable)e);
        }
        return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, Strings.format((String)"%s for request from inference entity id [%s]", (Object[])new Object[]{"Received an error response", request.getInferenceEntityId()}), "error", "stream_error");
    }
}

