/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.contextualai.request;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.contextualai.request.ContextualAiRerankRequestEntity;
import org.elasticsearch.xpack.inference.services.contextualai.rerank.ContextualAiRerankModel;

public class ContextualAiRerankRequest
implements Request {
    private static final Logger logger = LogManager.getLogger(ContextualAiRerankRequest.class);
    private final String query;
    private final List<String> documents;
    private final Integer topN;
    private final String instruction;
    private final ContextualAiRerankModel model;

    public ContextualAiRerankRequest(String query, List<String> documents, @Nullable Integer topN, @Nullable String instruction, ContextualAiRerankModel model) {
        this.query = Objects.requireNonNull(query);
        this.documents = Objects.requireNonNull(documents);
        this.topN = topN;
        this.instruction = instruction;
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public HttpRequest createHttpRequest() {
        String requestJson;
        HttpPost httpPost = new HttpPost(this.model.uri());
        ContextualAiRerankRequestEntity requestEntity = new ContextualAiRerankRequestEntity(this.query, this.documents, this.getTopN(), this.instruction, this.model);
        try {
            requestJson = Strings.toString((ToXContent)requestEntity);
            logger.debug("ContextualAI JSON Request: {}", (Object)requestJson);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize ContextualAI request entity", e);
        }
        ByteArrayEntity byteEntity = new ByteArrayEntity(requestJson.getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaTypeWithoutParameters());
        this.decorateWithAuth(httpPost);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    void decorateWithAuth(HttpPost httpPost) {
        SecureString apiKey = this.model.apiKey();
        if (apiKey != null) {
            httpPost.setHeader(RequestUtils.createAuthBearerHeader(apiKey));
        }
    }

    @Override
    public String getInferenceEntityId() {
        return this.model != null ? this.model.getInferenceEntityId() : "unknown";
    }

    @Override
    public URI getURI() {
        return this.model != null ? this.model.uri() : null;
    }

    public Integer getTopN() {
        return this.topN != null ? this.topN : (this.model.getTaskSettings() != null ? this.model.getTaskSettings().getTopN() : null);
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

