/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CagraIndexParams;

public class CuVSIvfPqSearchParams {
    private final int nProbes;
    private final CagraIndexParams.CudaDataType lutDtype;
    private final CagraIndexParams.CudaDataType internalDistanceDtype;
    private final double preferredShmemCarveout;

    private CuVSIvfPqSearchParams(int nProbes, CagraIndexParams.CudaDataType lutDtype, CagraIndexParams.CudaDataType internalDistanceDtype, double preferredShmemCarveout) {
        this.nProbes = nProbes;
        this.lutDtype = lutDtype;
        this.internalDistanceDtype = internalDistanceDtype;
        this.preferredShmemCarveout = preferredShmemCarveout;
    }

    public int getnProbes() {
        return this.nProbes;
    }

    public CagraIndexParams.CudaDataType getLutDtype() {
        return this.lutDtype;
    }

    public CagraIndexParams.CudaDataType getInternalDistanceDtype() {
        return this.internalDistanceDtype;
    }

    public double getPreferredShmemCarveout() {
        return this.preferredShmemCarveout;
    }

    public String toString() {
        return "CuVSIvfPqSearchParams [nProbes=" + this.nProbes + ", lutDtype=" + String.valueOf((Object)this.lutDtype) + ", internalDistanceDtype=" + String.valueOf((Object)this.internalDistanceDtype) + ", preferredShmemCarveout=" + this.preferredShmemCarveout + "]";
    }

    public static class Builder {
        private int nProbes = 20;
        private CagraIndexParams.CudaDataType lutDtype = CagraIndexParams.CudaDataType.CUDA_R_32F;
        private CagraIndexParams.CudaDataType internalDistanceDtype = CagraIndexParams.CudaDataType.CUDA_R_32F;
        private double preferredShmemCarveout = 1.0;

        public Builder withNProbes(int nProbes) {
            this.nProbes = nProbes;
            return this;
        }

        public Builder withLutDtype(CagraIndexParams.CudaDataType lutDtype) {
            this.lutDtype = lutDtype;
            return this;
        }

        public Builder withInternalDistanceDtype(CagraIndexParams.CudaDataType internalDistanceDtype) {
            this.internalDistanceDtype = internalDistanceDtype;
            return this;
        }

        public Builder withPreferredShmemCarveout(double preferredShmemCarveout) {
            this.preferredShmemCarveout = preferredShmemCarveout;
            return this;
        }

        public CuVSIvfPqSearchParams build() {
            return new CuVSIvfPqSearchParams(this.nProbes, this.lutDtype, this.internalDistanceDtype, this.preferredShmemCarveout);
        }
    }
}

