/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.local.EmptyLocalSupplier;
import org.elasticsearch.xpack.esql.plan.logical.local.ImmediateLocalSupplier;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class LocalSourceExec
extends LeafExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "LocalSourceExec", LocalSourceExec::new);
    private static final TransportVersion ESQL_LOCAL_RELATION_WITH_NEW_BLOCKS = TransportVersion.fromName((String)"esql_local_relation_with_new_blocks");
    private final List<Attribute> output;
    private final LocalSupplier supplier;

    public LocalSourceExec(Source source, List<Attribute> output, LocalSupplier supplier) {
        super(source);
        this.output = output;
        this.supplier = supplier;
    }

    public LocalSourceExec(StreamInput in) throws IOException {
        super(Source.readFrom((StreamInput)((PlanStreamInput)in)));
        this.output = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.supplier = in.getTransportVersion().supports(ESQL_LOCAL_RELATION_WITH_NEW_BLOCKS) ? (LocalSupplier)in.readNamedWriteable(LocalSupplier.class) : LocalSourceExec.readLegacyLocalSupplierFrom((PlanStreamInput)in);
    }

    public static LocalSupplier readLegacyLocalSupplierFrom(PlanStreamInput in) throws IOException {
        Block[] blocks = in.readCachedBlockArray();
        return blocks.length == 0 ? EmptyLocalSupplier.EMPTY : LocalSupplier.of(blocks);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteableCollection(this.output);
        if (out.getTransportVersion().supports(ESQL_LOCAL_RELATION_WITH_NEW_BLOCKS)) {
            out.writeNamedWriteable((NamedWriteable)this.supplier);
        } else if (this.supplier == EmptyLocalSupplier.EMPTY) {
            out.writeVInt(0);
        } else {
            ((ImmediateLocalSupplier)this.supplier).writeTo(out);
        }
    }

    public String getWriteableName() {
        return LocalSourceExec.ENTRY.name;
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    public LocalSupplier supplier() {
        return this.supplier;
    }

    protected NodeInfo<LocalSourceExec> info() {
        return NodeInfo.create((Node)this, LocalSourceExec::new, this.output, (Object)this.supplier);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LocalSourceExec other = (LocalSourceExec)((Object)o);
        return Objects.equals(this.supplier, other.supplier) && Objects.equals(this.output, other.output);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.output, this.supplier);
    }
}

