/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationPlanVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.optimizer.PostOptimizationPhasePlanVerifier;
import org.elasticsearch.xpack.esql.optimizer.rules.PlanConsistencyChecker;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public final class LogicalVerifier
extends PostOptimizationPhasePlanVerifier<LogicalPlan> {
    public static final LogicalVerifier LOCAL_INSTANCE = new LogicalVerifier(true);
    public static final LogicalVerifier INSTANCE = new LogicalVerifier(false);

    private LogicalVerifier(boolean isLocal) {
        super(isLocal);
    }

    @Override
    void checkPlanConsistency(LogicalPlan optimizedPlan, Failures failures, Failures depFailures) {
        ArrayList checkers = new ArrayList();
        optimizedPlan.forEachUp(p -> {
            PlanConsistencyChecker.checkPlan(p, depFailures);
            if (!failures.hasFailures()) {
                PostOptimizationVerificationAware pova;
                if (p instanceof PostOptimizationVerificationAware && !((pova = (PostOptimizationVerificationAware)((Object)p)) instanceof PostOptimizationVerificationAware.CoordinatorOnly && this.isLocal)) {
                    pova.postOptimizationVerification(failures);
                }
                if (p instanceof PostOptimizationPlanVerificationAware) {
                    PostOptimizationPlanVerificationAware popva = (PostOptimizationPlanVerificationAware)((Object)p);
                    checkers.add(popva.postOptimizationPlanVerification());
                }
                p.forEachExpression(ex -> {
                    PostOptimizationVerificationAware va;
                    if (ex instanceof PostOptimizationVerificationAware && !((va = (PostOptimizationVerificationAware)ex) instanceof PostOptimizationVerificationAware.CoordinatorOnly && this.isLocal)) {
                        va.postOptimizationVerification(failures);
                    }
                });
            }
        });
        optimizedPlan.forEachUp(p -> checkers.forEach(checker -> checker.accept(p, failures)));
    }
}

