/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.jdk;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;

class LinkerHelper {
    private static final Linker LINKER = Linker.nativeLinker();
    private static final SymbolLookup SYMBOL_LOOKUP;
    private static final MethodHandles.Lookup MH_LOOKUP;

    LinkerHelper() {
    }

    static MemorySegment functionAddress(String function) {
        return SYMBOL_LOOKUP.find(function).orElseThrow(() -> new LinkageError("Native function " + function + " could not be found"));
    }

    static MethodHandle downcallHandle(String function, FunctionDescriptor functionDescriptor, Linker.Option ... options) {
        return LINKER.downcallHandle(LinkerHelper.functionAddress(function), functionDescriptor, options);
    }

    static MethodHandle upcallHandle(Class<?> clazz, String methodName, FunctionDescriptor functionDescriptor) {
        try {
            return MH_LOOKUP.findVirtual(clazz, methodName, functionDescriptor.toMethodType());
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    static <T> MemorySegment upcallStub(MethodHandle mh, T instance, FunctionDescriptor functionDescriptor, Arena arena) {
        try {
            mh = mh.bindTo(instance);
            return LINKER.upcallStub(mh, functionDescriptor, arena, new Linker.Option[0]);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    static {
        MH_LOOKUP = MethodHandles.lookup();
        SymbolLookup loaderLookup = SymbolLookup.loaderLookup();
        SYMBOL_LOOKUP = name -> loaderLookup.find(name).or(() -> LINKER.defaultLookup().find(name));
    }
}

