/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.nulls;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class CheckNullProcessor
implements Processor {
    public static final String NAME = "nckn";
    private final CheckNullOperation operation;

    CheckNullProcessor(CheckNullOperation operation) {
        this.operation = operation;
    }

    public CheckNullProcessor(StreamInput in) throws IOException {
        this((CheckNullOperation)in.readEnum(CheckNullOperation.class));
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.operation);
    }

    @Override
    public Object process(Object input) {
        return this.operation.test(input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckNullProcessor that = (CheckNullProcessor)o;
        return this.operation == that.operation;
    }

    public int hashCode() {
        return Objects.hash(this.operation);
    }

    public static enum CheckNullOperation implements Predicate<Object>
    {
        IS_NULL(Objects::isNull, "IS NULL"),
        IS_NOT_NULL(Objects::nonNull, "IS NOT NULL");

        private final Predicate<Object> process;
        private final String symbol;

        private CheckNullOperation(Predicate<Object> process, String symbol) {
            this.process = process;
            this.symbol = symbol;
        }

        public String symbol() {
            return this.symbol;
        }

        public String toString() {
            return this.symbol;
        }

        @Override
        public boolean test(Object o) {
            return this.process.test(o);
        }
    }
}

