/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InferenceMetadataFieldsMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldBlockLoader;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentGenerator;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class SourceFieldMapper
extends MetadataFieldMapper {
    public static final NodeFeature REMOVE_SYNTHETIC_SOURCE_ONLY_VALIDATION = new NodeFeature("mapper.source.remove_synthetic_source_only_validation");
    public static final NodeFeature SOURCE_MODE_FROM_INDEX_SETTING = new NodeFeature("mapper.source.mode_from_index_setting");
    public static final NodeFeature SYNTHETIC_RECOVERY_SOURCE = new NodeFeature("mapper.synthetic_recovery_source");
    public static final String NAME = "_source";
    public static final String RECOVERY_SOURCE_NAME = "_recovery_source";
    public static final String RECOVERY_SOURCE_SIZE_NAME = "_recovery_source_size";
    public static final String CONTENT_TYPE = "_source";
    public static final String LOSSY_PARAMETERS_ALLOWED_SETTING_NAME = "index.lossy.source-mapping-parameters";
    public static final String DEPRECATION_WARNING_TITLE = "Configuring source mode in mappings is deprecated.";
    public static final String DEPRECATION_WARNING = "Configuring source mode in mappings is deprecated and will be removed in future versions. Use [index.mapping.source.mode] index setting instead.";
    private static final SourceFieldMapper DEFAULT = new SourceFieldMapper(null, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, false, false);
    private static final SourceFieldMapper STORED = new SourceFieldMapper(Mode.STORED, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, false, false);
    private static final SourceFieldMapper SYNTHETIC = new SourceFieldMapper(Mode.SYNTHETIC, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, false, false);
    private static final SourceFieldMapper DISABLED = new SourceFieldMapper(Mode.DISABLED, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, false, false);
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> {
        IndexMode indexMode = c.getIndexSettings().getMode();
        if (indexMode == IndexMode.TIME_SERIES && c.getIndexSettings().getIndexVersionCreated().before(IndexVersions.V_8_7_0)) {
            return DEFAULT;
        }
        Mode settingSourceMode = IndexSettings.INDEX_MAPPER_SOURCE_MODE_SETTING.get(c.getSettings());
        if (indexMode == IndexMode.STANDARD && settingSourceMode == Mode.STORED) {
            return DEFAULT;
        }
        SourceFieldMapper sourceFieldMapper = SourceFieldMapper.onOrAfterDeprecateModeVersion(c.indexVersionCreated()) ? SourceFieldMapper.resolveStaticInstance(settingSourceMode) : new SourceFieldMapper(settingSourceMode, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, true, c.indexVersionCreated().onOrAfter(IndexVersions.SOURCE_MAPPER_MODE_ATTRIBUTE_NOOP));
        indexMode.validateSourceFieldMapper(sourceFieldMapper);
        return sourceFieldMapper;
    }, c -> new Builder(c.getIndexSettings().getMode(), c.getSettings(), c.indexVersionCreated().onOrAfter(IndexVersions.SOURCE_MAPPER_MODE_ATTRIBUTE_NOOP), c.indexVersionCreated().onOrAfter(IndexVersions.SOURCE_MAPPER_LOSSY_PARAMS_CHECK), !SourceFieldMapper.onOrAfterDeprecateModeVersion(c.indexVersionCreated())));
    @Nullable
    private final Mode mode;
    private final boolean serializeMode;
    private final boolean sourceModeIsNoop;
    private final Explicit<Boolean> enabled;
    private final boolean complete;
    private final String[] includes;
    private final String[] excludes;
    private final SourceFilter sourceFilter;

    private static SourceFieldMapper toType(FieldMapper in) {
        return (SourceFieldMapper)in;
    }

    private static SourceFieldMapper resolveStaticInstance(Mode sourceMode) {
        return switch (sourceMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> SYNTHETIC;
            case 1 -> STORED;
            case 0 -> DISABLED;
        };
    }

    private SourceFieldMapper(Mode mode, Explicit<Boolean> enabled, String[] includes, String[] excludes, boolean serializeMode, boolean sourceModeIsNoop) {
        super(new SourceFieldType(enabled.explicit() && enabled.value() != false || !enabled.explicit() && mode != Mode.DISABLED));
        this.mode = mode;
        this.enabled = enabled;
        this.sourceFilter = SourceFieldMapper.buildSourceFilter(includes, excludes);
        this.includes = includes;
        this.excludes = excludes;
        this.complete = this.stored() && this.sourceFilter == null;
        this.serializeMode = serializeMode;
        this.sourceModeIsNoop = sourceModeIsNoop;
    }

    private static SourceFilter buildSourceFilter(String[] includes, String[] excludes) {
        if (CollectionUtils.isEmpty(includes) && CollectionUtils.isEmpty(excludes)) {
            return null;
        }
        return new SourceFilter(includes, excludes);
    }

    private boolean stored() {
        if (this.enabled.explicit() || this.mode == null) {
            return this.enabled.value();
        }
        return this.mode == Mode.STORED;
    }

    public boolean enabled() {
        if (this.enabled.explicit()) {
            return this.enabled.value();
        }
        if (this.mode != null) {
            return this.mode != Mode.DISABLED;
        }
        return this.enabled.value();
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void preParse(DocumentParserContext context) throws IOException {
        XContentType contentType = context.sourceToParse().getXContentType();
        BytesReference originalSource = context.sourceToParse().source();
        BytesReference storedSource = this.stored() ? this.removeSyntheticVectorFields(context.mappingLookup(), originalSource, contentType) : null;
        BytesReference adaptedStoredSource = this.applyFilters(context.mappingLookup(), storedSource, contentType, false);
        if (adaptedStoredSource != null) {
            BytesRef ref = adaptedStoredSource.toBytesRef();
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), ref.bytes, ref.offset, ref.length));
        }
        if (!context.indexSettings().isRecoverySourceEnabled()) {
            return;
        }
        if (context.indexSettings().isRecoverySourceSyntheticEnabled()) {
            assert (this.isSynthetic()) : "Recovery source should not be disabled for non-synthetic sources";
            context.doc().add((IndexableField)new NumericDocValuesField(RECOVERY_SOURCE_SIZE_NAME, (long)originalSource.length()));
        } else if (!this.stored() || adaptedStoredSource != storedSource) {
            BytesRef recoverySource = this.removeSyntheticVectorFields(context.mappingLookup(), originalSource, contentType).toBytesRef();
            context.doc().add((IndexableField)new StoredField(RECOVERY_SOURCE_NAME, recoverySource.bytes, recoverySource.offset, recoverySource.length));
            context.doc().add((IndexableField)new NumericDocValuesField(RECOVERY_SOURCE_NAME, 1L));
        }
    }

    private BytesReference removeSyntheticVectorFields(MappingLookup mappingLookup, @Nullable BytesReference originalSource, @Nullable XContentType contentType) throws IOException {
        if (originalSource == null) {
            return null;
        }
        HashSet<String> excludes = new HashSet<String>();
        if (InferenceMetadataFieldsMapper.isEnabled(mappingLookup) && !mappingLookup.inferenceFields().isEmpty()) {
            excludes.add("_inference_fields");
        }
        if (excludes.isEmpty() && mappingLookup.syntheticVectorFields().isEmpty()) {
            return originalSource;
        }
        BytesStreamOutput streamOutput = new BytesStreamOutput();
        XContentBuilder builder = new XContentBuilder(contentType.xContent(), (OutputStream)streamOutput);
        try (XContentParser parser = XContentHelper.createParserNotCompressed(XContentParserConfiguration.EMPTY.withFiltering(Set.of(), excludes, true), originalSource, contentType);){
            if (parser.currentToken() == null && parser.nextToken() == null) {
                BytesReference bytesReference = originalSource;
                return bytesReference;
            }
            SourceFieldMapper.removeSyntheticVectorFields(builder.generator(), parser, "", mappingLookup.syntheticVectorFields());
            BytesReference bytesReference = BytesReference.bytes(builder);
            return bytesReference;
        }
    }

    @Nullable
    public BytesReference applyFilters(MappingLookup mappingLookup, @Nullable BytesReference originalSource, @Nullable XContentType contentType, boolean removeMetadataFields) throws IOException {
        if (!this.stored() || originalSource == null) {
            return null;
        }
        SourceFilter modSourceFilter = this.sourceFilter;
        if (removeMetadataFields && InferenceMetadataFieldsMapper.isEnabled(mappingLookup) && !mappingLookup.inferenceFields().isEmpty()) {
            String[] modExcludes = new String[this.excludes != null ? this.excludes.length + 1 : 1];
            if (this.excludes != null) {
                System.arraycopy(this.excludes, 0, modExcludes, 0, this.excludes.length);
            }
            modExcludes[modExcludes.length - 1] = "_inference_fields";
            modSourceFilter = new SourceFilter(this.includes, modExcludes);
        }
        if (modSourceFilter != null) {
            return Source.fromBytes(originalSource, contentType).filter(modSourceFilter).internalSourceRef();
        }
        return originalSource;
    }

    @Override
    protected String contentType() {
        return "_source";
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(null, Settings.EMPTY, this.sourceModeIsNoop, false, this.serializeMode).init(this);
    }

    public boolean isSynthetic() {
        return this.mode == Mode.SYNTHETIC;
    }

    public static boolean isSynthetic(IndexSettings indexSettings) {
        return IndexSettings.INDEX_MAPPER_SOURCE_MODE_SETTING.get(indexSettings.getSettings()) == Mode.SYNTHETIC;
    }

    public static boolean isStored(IndexSettings indexSettings) {
        return IndexSettings.INDEX_MAPPER_SOURCE_MODE_SETTING.get(indexSettings.getSettings()) == Mode.STORED;
    }

    public boolean isDisabled() {
        return this.mode == Mode.DISABLED;
    }

    public boolean isStored() {
        return this.mode == null || this.mode == Mode.STORED;
    }

    public static boolean onOrAfterDeprecateModeVersion(IndexVersion version) {
        return version.onOrAfter(IndexVersions.DEPRECATE_SOURCE_MODE_MAPPER) || version.between(IndexVersions.V8_DEPRECATE_SOURCE_MODE_MAPPER, IndexVersions.UPGRADE_TO_LUCENE_10_0_0);
    }

    private static void removeSyntheticVectorFields(XContentGenerator destination, XContentParser parser, String fullPath, Set<String> patchFullPaths) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.FIELD_NAME) {
            String fieldName = parser.currentName();
            token = parser.nextToken();
            if (patchFullPaths.contains(fullPath = (String)fullPath + (((String)fullPath).isEmpty() ? "" : ".") + fieldName)) {
                parser.skipChildren();
                return;
            }
            destination.writeFieldName(fieldName);
        }
        switch (token) {
            case START_ARRAY: {
                destination.writeStartArray();
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    SourceFieldMapper.removeSyntheticVectorFields(destination, parser, (String)fullPath, patchFullPaths);
                }
                destination.writeEndArray();
                break;
            }
            case START_OBJECT: {
                destination.writeStartObject();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    SourceFieldMapper.removeSyntheticVectorFields(destination, parser, (String)fullPath, patchFullPaths);
                }
                destination.writeEndObject();
                break;
            }
            default: {
                destination.copyCurrentEvent(parser);
            }
        }
    }

    public static enum Mode {
        DISABLED,
        STORED,
        SYNTHETIC;

    }

    static final class SourceFieldType
    extends MappedFieldType {
        private final boolean enabled;

        private SourceFieldType(boolean enabled) {
            super("_source", false, enabled, false, Collections.emptyMap());
            this.enabled = enabled;
        }

        @Override
        public String typeName() {
            return "_source";
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new IllegalArgumentException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, "The _source field is not searchable", new Object[0]);
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, "The _source field is not searchable", new Object[0]);
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.enabled) {
                return new SourceFieldBlockLoader();
            }
            return BlockLoader.CONSTANT_NULLS;
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final FieldMapper.Parameter<Explicit<Boolean>> enabled = FieldMapper.Parameter.explicitBoolParam("enabled", false, m -> SourceFieldMapper.toType((FieldMapper)m).enabled, true).setSerializerCheck((includeDefaults, isConfigured, value) -> value.explicit()).setMergeValidator((previous, current, conflicts) -> previous.value() == current.value() || (Boolean)previous.value() != false && (Boolean)current.value() == false);
        private final FieldMapper.Parameter<Mode> mode;
        private final FieldMapper.Parameter<List<String>> includes = FieldMapper.Parameter.stringArrayParam("includes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).includes));
        private final FieldMapper.Parameter<List<String>> excludes = FieldMapper.Parameter.stringArrayParam("excludes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).excludes));
        private final Settings settings;
        private final IndexMode indexMode;
        private boolean serializeMode;
        private final boolean supportsNonDefaultParameterValues;
        private final boolean sourceModeIsNoop;

        public Builder(IndexMode indexMode, Settings settings, boolean sourceModeIsNoop, boolean supportsCheckForNonDefaultParams, boolean serializeMode) {
            super("_source");
            this.settings = settings;
            this.indexMode = indexMode;
            this.supportsNonDefaultParameterValues = !supportsCheckForNonDefaultParams || settings.getAsBoolean(SourceFieldMapper.LOSSY_PARAMETERS_ALLOWED_SETTING_NAME, true) != false;
            this.sourceModeIsNoop = sourceModeIsNoop;
            this.serializeMode = serializeMode;
            this.mode = new FieldMapper.Parameter<Mode>("mode", true, () -> null, (n, c, o) -> Mode.valueOf(o.toString().toUpperCase(Locale.ROOT)), m -> {
                SourceFieldMapper sfm = SourceFieldMapper.toType(m);
                if (sfm.enabled.explicit()) {
                    return null;
                }
                if (sfm.serializeMode) {
                    return sfm.mode;
                }
                return null;
            }, (b, n, v) -> b.field(n, v.toString().toLowerCase(Locale.ROOT)), v -> v.toString().toLowerCase(Locale.ROOT)).setMergeValidator((previous, current, conflicts) -> previous == current || current != Mode.STORED).setSerializerCheck((includeDefaults, isConfigured, value) -> serializeMode && value != null);
        }

        public Builder setSynthetic() {
            this.mode.setValue(Mode.SYNTHETIC);
            return this;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.enabled, this.mode, this.includes, this.excludes};
        }

        private boolean isDefault() {
            return this.enabled.get().value() != false && this.includes.getValue().isEmpty() && this.excludes.getValue().isEmpty();
        }

        @Override
        public SourceFieldMapper build() {
            if (this.enabled.getValue().explicit() && this.mode.get() != null) {
                throw new MapperParsingException("Cannot set both [mode] and [enabled] parameters");
            }
            Mode sourceMode = this.resolveSourceMode();
            if (!this.supportsNonDefaultParameterValues) {
                ArrayList<String> disallowed = new ArrayList<String>();
                if (!this.enabled.get().value().booleanValue()) {
                    disallowed.add("enabled");
                }
                if (!this.includes.get().isEmpty()) {
                    disallowed.add("includes");
                }
                if (!this.excludes.get().isEmpty()) {
                    disallowed.add("excludes");
                }
                if (this.mode.get() == Mode.DISABLED) {
                    disallowed.add("mode=disabled");
                }
                if (!disallowed.isEmpty()) {
                    throw new MapperParsingException(disallowed.size() == 1 ? "Parameter [" + (String)disallowed.get(0) + "] is not allowed in source" : "Parameters [" + String.join((CharSequence)",", disallowed) + "] are not allowed in source");
                }
            }
            if (!(sourceMode != Mode.SYNTHETIC || this.includes.getValue().isEmpty() && this.excludes.getValue().isEmpty())) {
                throw new IllegalArgumentException("filtering the stored _source is incompatible with synthetic source");
            }
            if (this.mode.isConfigured() && !this.sourceModeIsNoop) {
                this.serializeMode = true;
            }
            SourceFieldMapper sourceFieldMapper = this.isDefault() && sourceMode == null ? DEFAULT : (this.isDefault() && !this.serializeMode && sourceMode != null ? SourceFieldMapper.resolveStaticInstance(sourceMode) : new SourceFieldMapper(sourceMode, this.enabled.get(), this.includes.getValue().toArray(Strings.EMPTY_ARRAY), this.excludes.getValue().toArray(Strings.EMPTY_ARRAY), this.serializeMode, this.sourceModeIsNoop));
            if (this.indexMode != null) {
                this.indexMode.validateSourceFieldMapper(sourceFieldMapper);
            }
            return sourceFieldMapper;
        }

        private Mode resolveSourceMode() {
            if (IndexSettings.INDEX_MAPPER_SOURCE_MODE_SETTING.exists(this.settings)) {
                return IndexSettings.INDEX_MAPPER_SOURCE_MODE_SETTING.get(this.settings);
            }
            if (this.mode.get() == null || this.sourceModeIsNoop) {
                if (this.indexMode == null || this.indexMode == IndexMode.STANDARD) {
                    return null;
                }
                return this.indexMode.defaultSourceMode();
            }
            return this.mode.get();
        }
    }

    public static class Defaults {
        public static final String NAME = "_source";
        public static final FieldType FIELD_TYPE;

        static {
            FieldType ft = new FieldType();
            ft.setIndexOptions(IndexOptions.NONE);
            ft.setStored(true);
            ft.setOmitNorms(true);
            FIELD_TYPE = Mapper.freezeAndDeduplicateFieldType(ft);
        }
    }
}

