/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai;

import java.io.IOException;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.inference.common.DelegatingProcessor;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEvent;

public class OpenAiStreamingProcessor
extends DelegatingProcessor<Deque<ServerSentEvent>, InferenceServiceResults.Result> {
    private static final Logger log = LogManager.getLogger(OpenAiStreamingProcessor.class);
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in OpenAI chat completions response";
    private static final String CHOICES_FIELD = "choices";
    private static final String DELTA_FIELD = "delta";
    private static final String CONTENT_FIELD = "content";
    private static final String DONE_MESSAGE = "[done]";

    @Override
    protected void next(Deque<ServerSentEvent> item) throws Exception {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        Deque results = OpenAiStreamingProcessor.parseEvent(item, OpenAiStreamingProcessor::parse, parserConfig);
        if (results.isEmpty()) {
            this.upstream().request(1L);
        } else {
            this.downstream().onNext(new StreamingChatCompletionResults.Results(results));
        }
    }

    public static Stream<StreamingChatCompletionResults.Result> parse(XContentParserConfiguration parserConfig, ServerSentEvent event) {
        Stream<StreamingChatCompletionResults.Result> stream;
        block9: {
            if (DONE_MESSAGE.equalsIgnoreCase(event.data())) {
                return Stream.empty();
            }
            XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, event.data());
            try {
                XContentUtils.moveToFirstToken(jsonParser);
                XContentParser.Token token = jsonParser.currentToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)jsonParser);
                XContentUtils.positionParserAtTokenAfterField(jsonParser, CHOICES_FIELD, FAILED_TO_FIND_FIELD_TEMPLATE);
                stream = XContentParserUtils.parseList((XContentParser)jsonParser, parser -> {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    XContentUtils.positionParserAtTokenAfterField(parser, DELTA_FIELD, FAILED_TO_FIND_FIELD_TEMPLATE);
                    XContentParser.Token currentToken = parser.currentToken();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)currentToken, (XContentParser)parser);
                    currentToken = parser.nextToken();
                    while (currentToken != null && currentToken != XContentParser.Token.END_OBJECT) {
                        if (currentToken == XContentParser.Token.START_OBJECT || currentToken == XContentParser.Token.START_ARRAY) {
                            parser.skipChildren();
                        }
                        if (currentToken == XContentParser.Token.FIELD_NAME && parser.currentName().equals(CONTENT_FIELD)) {
                            parser.nextToken();
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_STRING, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                            String content = parser.text();
                            XContentUtils.consumeUntilObjectEnd(parser);
                            XContentUtils.consumeUntilObjectEnd(parser);
                            return content;
                        }
                        currentToken = parser.nextToken();
                    }
                    XContentUtils.consumeUntilObjectEnd(parser);
                    return "";
                }).stream().filter(Objects::nonNull).filter(Predicate.not(String::isEmpty)).map(StreamingChatCompletionResults.Result::new);
                if (jsonParser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonParser != null) {
                        try {
                            jsonParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchStatusException("Failed to parse event from inference provider: {}", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[]{event});
                }
            }
            jsonParser.close();
        }
        return stream;
    }
}

